// var builder = WebApplication.CreateBuilder(args);

// // Add services to the container.
// builder.Services.AddControllersWithViews();

// var app = builder.Build();

// // Configure the HTTP request pipeline.
// if (!app.Environment.IsDevelopment())
// {
//     app.UseExceptionHandler("/Home/Error");
//     // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
//     app.UseHsts();
// }

// app.UseHttpsRedirection();
// app.UseStaticFiles();

// app.UseRouting();

// app.UseAuthorization();

// app.MapControllerRoute(
//     name: "default",
//     pattern: "{controller=Home}/{action=Index}/{id?}");

// app.Run();

using FTP_Services.Services;
using FTP_Services.Core.Models;
using Microsoft.AspNetCore.Http.Features;
using Prometheus;
using Prometheus.SystemMetrics;

//log4netConfig.Load(File.OpenRead("log4net.config"));
try
{
    string? curPath = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location);
    if (String.IsNullOrEmpty(curPath))
        curPath = System.Environment.CurrentDirectory;

    string confFile = Path.Combine(curPath, "log4net.config");
    var repo = log4net.LogManager.CreateRepository(System.Reflection.Assembly.GetEntryAssembly(),
                           typeof(log4net.Repository.Hierarchy.Hierarchy));
    //log4net.Config.XmlConfigurator.Configure(repo, log4netConfig["log4net"]);
    log4net.Config.XmlConfigurator.Configure(new System.IO.FileInfo(confFile));
    log4net.ILog log = log4net.LogManager.GetLogger("Progaram Main");
    log.Info("************************     Starting the ADRCP Connect Services **************************************************************** ");
}
catch (Exception ex)
{
    Console.WriteLine($"Fail to load log4net config file, log will be disabled {ex.Message}");
}

var builder = WebApplication.CreateBuilder(args);

// Add services to the container.

builder.Services.AddControllers();
// Learn more about configuring Swagger/OpenAPI at https://aka.ms/aspnetcore/swashbuckle
builder.Services.AddEndpointsApiExplorer();
builder.Services.AddSwaggerGen();

builder.Services.AddSwaggerGen(c =>
    {
        //c.SwaggerDoc("v1", new OpenApiInfo { Title = "Sample.FileUpload.Api", Version = "v1" });  
        c.OperationFilter<SwaggerFileOperationFilter>();
    });





// configure strongly typed settings object
builder.Services.Configure<AppSettings>(builder.Configuration.GetSection("AppSettings"));

builder.Services.Configure<FormOptions>(x =>
{
    x.ValueLengthLimit = int.MaxValue;
    x.MultipartBodyLengthLimit = int.MaxValue; // In case of multipart
});

// builder.Services.AddScoped<IUserService, UserService>();
builder.Services.AddControllersWithViews();

var app = builder.Build();
//check matrics at http://host/metrics
app.UseMetricServer();
app.UseHttpMetrics();


// global cors policy
app.UseCors(x => x
    .AllowAnyOrigin()
    .AllowAnyMethod()
    .AllowAnyHeader());

// Configure the HTTP request pipeline.
if (app.Environment.IsDevelopment())
{
    //app.UseDeveloperExceptionPage();
    //or
    app.UseSwagger();
    app.UseSwaggerUI();
}

//app.UseHttpsRedirection();

app.UseAuthorization();
// custom jwt auth middleware

// app.UseMiddleware<JwtMiddleware>();

app.MapControllerRoute(
    name: "default",
    pattern: "{controller=Home}/{action=Index}/{id?}");

app.MapControllers();

app.UseRouting();
app.UseDefaultFiles();
app.UseStaticFiles();
app.UseEndpoints(endpoints =>
{endpoints.MapControllers();
});
// app.UseEndpoints(endpoints =>
// {
//     endpoints.MapGet("/", async context =>
//     {
//        // await context.Response.WriteAsync("Hello World!");
       
//     });
// });

if (app.Environment.IsDevelopment())
{
    app.Run("http://localhost:5603");
}
else
{
    //app.Run(); //For Test Site
    //app.Run("http://*:4708"); // For Production
    app.Run("http://*:4709"); // For Admin

}

