using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Net;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using FTP_Services.Core.Models;
//using System.Web.Helpers;

using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Options;
using Npgsql;
using PetaPoco;

namespace FTP_Services.Services
{
    public class FTPDataAdapter : BaseDataAdapter
    {
        public FTPDataAdapter(AppSettings appSettings)
            : base(appSettings)
        {
            log.Debug("FTPDataAdapter() Called");
        }

        public List<Login>? LoginData(string sndUserName)
        {
            List<Login>? LoginData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    LoginData = _repository.Fetch<Login>(
                        "SELECT * FROM \"SPScanTool_GetLoginDetails\"(@Parm_UserName)",
                        new { Parm_UserName = sndUserName }
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return LoginData;
            }
            catch (Exception ex)
            {
                log.Error("LoginData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }

        // public List<SearchPatients>? SearchedPatientsData(string SearchText)
        // {
        //     List<SearchPatients>? SearchPatientsData = null;
        //     try
        //     {
        //         using (var tx = _repository.GetTransaction())
        //         {
        //             // Check if SearchText is null or empty and set it to a wildcard if true
        //             string searchTextParam = string.IsNullOrEmpty(SearchText) ? "%" : SearchText.Replace("'", "''");

        //             // Build the SQL query string
        //             string sqlQuery = $"SELECT * FROM \"SPScanTool_GetSearchedPatients\"(@Parm_SearchText)";

        //             // Perform the fetch operation with the constructed SQL query and parameter
        //             SearchPatientsData = _repository.Fetch<SearchPatients>(
        //                 sqlQuery,
        //                 new { Parm_SearchText = searchTextParam }
        //             );

        //             GC.Collect();
        //             tx.Complete();
        //         }
        //         return SearchPatientsData;
        //     }
        //     catch (Exception ex)
        //     {
        //         log.Error("SearchedPatientsData->Failed to get info from db - " + ex.Message);
        //         return null;
        //     }
        // }

        public List<object>? SearchedPatientsData(string SearchText)
        {
            List<object>? SearchPatientsData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string searchTextParam = string.IsNullOrEmpty(SearchText)
                        ? "%"
                        : SearchText.Replace("'", "''");
                    string sqlQuery =
                        $"SELECT * FROM \"SPScanTool_GetSearchedPatients\"(@Parm_SearchText)";
                    SearchPatientsData = _repository.Fetch<object>(
                        sqlQuery,
                        new { Parm_SearchText = searchTextParam }
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return SearchPatientsData;
            }
            catch (Exception ex)
            {
                log.Error("SearchedPatientsData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }

        public List<DocumentCategories>? DocumentCategories()
        {
            List<DocumentCategories>? DocumentCategoriesData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    DocumentCategoriesData = _repository.Fetch<DocumentCategories>(
                        "SELECT * FROM \"SPScanTool_LoadDocumentCategories\"()"
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return DocumentCategoriesData;
            }
            catch (Exception ex)
            {
                log.Error("DocumentCategories->Failed to get info from db - " + ex.Message);
                return null;
            }
        }
        // public List<ConfigValues>? ConfigValues(int CompanyId)
        // {
        //     List<ConfigValues>? ConfigValuesData = null;
        //     try
        //     {
        //         using (var tx = _repository.GetTransaction())
        //         {
        //             ConfigValuesData = _repository.Fetch<ConfigValues>(
        //                 "SELECT \"ID\", \"Environment\", \"RemotePath\", \"CompanyName\", \"FTPServiceURL\", \"DPI\", \"PDFSizeLimit\", \"DefaultDocType\", \"IsActive\" " +
        //                 "FROM \"ScanConfigMaster\" " +
        //                 "WHERE \"IsActive\" = TRUE " +
        //                 "ORDER BY \"CompanyName\""
        //             );
        //             GC.Collect();
        //             tx.Complete();
        //         }
        //         return ConfigValuesData;
        //     }
        //     catch (Exception ex)
        //     {
        //         log.Error("ConfigValues->Failed to get info from db - " + ex.Message);
        //         return null;
        //     }
        // }

        public List<ConfigValues>? ConfigValues(int CompanyId)
        {
            List<ConfigValues>? ConfigValuesData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    ConfigValuesData = _repository.Fetch<ConfigValues>(
                        "SELECT * FROM \"SPScanTool_GetScanConfigByCompanyId\"(@0)", CompanyId
                    );

                    GC.Collect();
                    tx.Complete();
                }
                return ConfigValuesData;
            }
            catch (Exception ex)
            {
                log.Error("ConfigValues->Failed to get info from db - " + ex.Message);
                return null;
            }
        }


        public List<Specialities>? Specialities()
        {
            List<Specialities>? SpecialitiesData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    //"select \"SpecializationId\" as \"ID\", \"SpecializationName\" \"Name\" from \"Specialization\" WHERE \"Active\" = true ORDER BY \"Name\""
                    SpecialitiesData = _repository.Fetch<Specialities>(
                         "SELECT * FROM \"SPScanTool_LoadDocumentCategories\"()"
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return SpecialitiesData;
            }
            catch (Exception ex)
            {
                log.Error("Specialities->Failed to get info from db - " + ex.Message);
                return null;
            }
        }

        public List<PatientDocuments>? PatientDocuments(int SPatientID, int SDocID)
        {
            List<PatientDocuments>? PatientDocumentsData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    PatientDocumentsData = _repository.Fetch<PatientDocuments>(
                        "SELECT * FROM \"SPScanTool_GetPatientDocuments\"("
                            + SPatientID.ToString()
                            + ","
                            + SDocID.ToString()
                            + ");"
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return PatientDocumentsData;
            }
            catch (Exception ex)
            {
                log.Error("PatientDocuments->Failed to get info from db - " + ex.Message);
                return null;
            }
        }

        public int SavePatientDocumentData(PatientDocumentDetailsModel SndPatDocRec)
        {
            int _save = 0;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string SQLStr =
                        "SELECT * FROM \"SPScanTool_SavePatientDocument\"("
                         + SndPatDocRec.PatDocId
                         + ",'"
                        + SndPatDocRec.UploadedDate
                         + "',"
                        + SndPatDocRec.PatientId
                        + ",'"
                        + SndPatDocRec.UploadedBy
                        + "','"
                        + SndPatDocRec.DocumentName
                        + "','"
                        + SndPatDocRec.DocumentType
                        + "','"
                        + SndPatDocRec.ContentType
                        + "',"
                        + SndPatDocRec.Size
                        + ",'"
                        + SndPatDocRec.Description
                        + "','"
                        + SndPatDocRec.DocumentUrl
                        + "','"
                        + SndPatDocRec.ThumbnailUrl
                        + "',"
                        + SndPatDocRec.SplID
                        + ")";
                    _save = _repository.Single<int>(SQLStr);
                    GC.Collect();
                    tx.Complete();
                }
            }
            catch (Exception ex)
            {
                log.Error("SavePatientDocumentData->Failed to get info from db - " + ex.Message);
            }
            return _save;
        }

        // public int DeletePatientDocumentData(int SndPatDocRecID)
        // {
        //     int _Delete = 0;
        //     try
        //     {
        //         using (var tx = _repository.GetTransaction())
        //         {
        //             string SQLStr =
        //                 "SELECT * FROM \"SPScanTool_DeletePatientDocument\"("
        //                 + SndPatDocRecID
        //                 + ");";
        //             _Delete = _repository.Single<int>(SQLStr);
        //             GC.Collect();
        //             tx.Complete();
        //         }
        //     }
        //     catch (Exception ex)
        //     {
        //         log.Error("DeletePatientDocumentData->Failed to get info from db - " + ex.Message);
        //     }
        //     return _Delete;
        // }

        public string DeletePatientDocumentData(int SndPatDocRecID)
        {
            string result = string.Empty;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string SQLStr =
                        "SELECT * FROM \"SPScanTool_DeletePatientDocument\"("
                        + SndPatDocRecID
                        + ");";

                    result = _repository.Single<string>(SQLStr);
                    result = "";

                    GC.Collect();
                    tx.Complete();
                }
            }
            catch (Exception ex)
            {
                log.Error("DeletePatientDocumentData->Failed to get info from db - " + ex.Message);
                result = "Error: " + ex.Message;
            }
            return result;
        }

        public bool IsValidUserData(string SndUserName, string SndPassword)
        {
            try
            {
                int count = 0;
                using (var tx = _repository.GetTransaction())
                {
                    count = _repository.Single<int>(
                        "SELECT COUNT(*) as \"RecordCount\" FROM \"Login\" WHERE \"Username\" = '"
                            + SndUserName
                            + "' AND \"Password\" = '"
                            + SndPassword
                            + "'"
                    );
                    GC.Collect();
                    tx.Complete();
                }
                if (count > 0)
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {
                log.Error("IsValidUserData->Failed to get info from db - " + ex.Message);
                return false;
            }
        }
    }
}
