using Microsoft.AspNetCore.Hosting;
using System;
using System.IO;

public class LogService
{
    private readonly IWebHostEnvironment _environment;

    public LogService(IWebHostEnvironment environment)
    {
        _environment = environment;
    }

    public void WriteLog(string SndException)
    {
        string strBaseDirectory = _environment.ContentRootPath;
        string strDirectory = Path.Combine(strBaseDirectory, "LOGDetails");
        if (!Directory.Exists(strDirectory))
        {
            Directory.CreateDirectory(strDirectory);
        }
        string strFile = Path.Combine(strDirectory, DateTime.Today.ToString("yyyy-MM-dd") + ".txt");
        using (StreamWriter objStreamWriter = new StreamWriter(strFile, true))
        {
            objStreamWriter.WriteLine(SndException);
        }
    }
}
