using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Net;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using FTP_Services.Core.Models;
//using System.Web.Helpers;

using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Options;
using Newtonsoft.Json;
using Npgsql;
using PetaPoco;

namespace FTP_Services.Services
{
    public class FTPDataAdapter : BaseDataAdapter
    {
        public FTPDataAdapter(AppSettings appSettings)
            : base(appSettings)
        {
            log.Debug("FTPDataAdapter() Called");
        }

        public List<Login>? LoginData(string sndUserName)
        {
            List<Login>? LoginData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    LoginData = _repository.Fetch<Login>(
                        "SELECT * FROM \"SPScanTool_GetLoginDetails\"(@Parm_UserName)",
                        new { Parm_UserName = sndUserName }
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return LoginData;
            }
            catch (Exception ex)
            {
                log.Error("LoginData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }

        // public List<SearchPatients>? SearchedPatientsData(string SearchText)
        // {
        //     List<SearchPatients>? SearchPatientsData = null;
        //     try
        //     {
        //         using (var tx = _repository.GetTransaction())
        //         {
        //             // Check if SearchText is null or empty and set it to a wildcard if true
        //             string searchTextParam = string.IsNullOrEmpty(SearchText) ? "%" : SearchText.Replace("'", "''");

        //             // Build the SQL query string
        //             string sqlQuery = $"SELECT * FROM \"SPScanTool_GetSearchedPatients\"(@Parm_SearchText)";

        //             // Perform the fetch operation with the constructed SQL query and parameter
        //             SearchPatientsData = _repository.Fetch<SearchPatients>(
        //                 sqlQuery,
        //                 new { Parm_SearchText = searchTextParam }
        //             );

        //             GC.Collect();
        //             tx.Complete();
        //         }
        //         return SearchPatientsData;
        //     }
        //     catch (Exception ex)
        //     {
        //         log.Error("SearchedPatientsData->Failed to get info from db - " + ex.Message);
        //         return null;
        //     }
        // }

        public List<object>? GetUserLocations(string sndUserName)
        {
            List<object>? UserLocationsData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string sqlQuery =
                        $"SELECT * FROM \"SPScanTool_GetUserLocations\"(@Parm_UserName)";
                    UserLocationsData = _repository.Fetch<object>(
                        sqlQuery,
                        new { Parm_UserName = sndUserName }
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return UserLocationsData;
            }
            catch (Exception ex)
            {
                log.Error("GetAdmissionData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }
        public List<object>? GetDepartments(int sndLocationId)
        {
            List<object>? DepartmentsData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string sqlQuery =
                        $"SELECT * FROM \"SPScanTool_GetDepartments\"(@Parm_LocationId)";
                    DepartmentsData = _repository.Fetch<object>(
                        sqlQuery,
                        new { Parm_LocationId = sndLocationId }
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return DepartmentsData;
            }
            catch (Exception ex)
            {
                log.Error("DepartmentsData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }

        public List<object>? GetWards(int sndLocationId)
        {
            List<object>? WardsData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string sqlQuery =
                        $"SELECT * FROM \"SPScanTool_GetWards\"(@Parm_LocationId)";
                    WardsData = _repository.Fetch<object>(
                        sqlQuery,
                        new { Parm_LocationId = sndLocationId }
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return WardsData;
            }
            catch (Exception ex)
            {
                log.Error("GetWards->Failed to get info from db - " + ex.Message);
                return null;
            }
        }
        public List<object>? GetAdmissionTypes()
        {
            List<object>? AdmissionTypesData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {

                    AdmissionTypesData = _repository.Fetch<object>(
                        "SELECT * FROM \"SPScanTool_GetAdmissionTypes\"();"
                    );

                    // string sqlQuery =
                    //     $"SELECT * FROM \"SPScanTool_GetAdmissionTypes\"()";
                    // AdmissionTypesData = _repository.Fetch<object>(
                    //     sqlQuery
                    // );
                    GC.Collect();
                    tx.Complete();
                }
                return AdmissionTypesData;
            }
            catch (Exception ex)
            {
                log.Error("AdmissionTypesData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }

        public List<object>? GetDischargeTypes()
        {
            List<object>? DischargeTypesData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {

                    DischargeTypesData = _repository.Fetch<object>(
                        "SELECT * FROM \"SPScanTool_GetDischargeTypes\"();"
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return DischargeTypesData;
            }
            catch (Exception ex)
            {
                log.Error("GetDischargeTypes->Failed to get info from db - " + ex.Message);
                return null;
            }
        }
        public List<object>? LoadICD()
        {
            List<object>? ICDData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {

                    ICDData = _repository.Fetch<object>(
                        "SELECT * FROM \"SPScanTool_LoadICD\"();"
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return ICDData;
            }
            catch (Exception ex)
            {
                log.Error("LoadICD->Failed to get info from db - " + ex.Message);
                return null;
            }
        }
        public List<object>? LoadDocumentTypes()
        {
            List<object>? DocumentTypesData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {

                    DocumentTypesData = _repository.Fetch<object>(
                        "SELECT * FROM \"SPScanTool_LoadDocumentTypes\"();"
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return DocumentTypesData;
            }
            catch (Exception ex)
            {
                log.Error("DocumentTypesData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }


        public List<object>? GeLoadPhysicians(int sndLocationId,Boolean sndIsOldData)
        {
            List<object>? PhysiciansData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string sqlQuery =
                        $"SELECT * FROM \"SPScanTool_LoadPhysicians\"(@Parm_LocationId,@Param_IsOldData)";
                    PhysiciansData = _repository.Fetch<object>(
                        sqlQuery,
                        new { Parm_LocationId = sndLocationId,Param_IsOldData = sndIsOldData }
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return PhysiciansData;
            }
            catch (Exception ex)
            {
                log.Error("GeLoadPhysicians->Failed to get info from db - " + ex.Message);
                return null;
            }
        }
         public List<object>? GetAdmissionDataHistory(int PatientID, int LocationID, int ProviderID, int DateType, string StartDate, string EndDate)
        {
            List<object>? AdmissionDataHistory = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string sqlQuery =
                        $"SELECT * FROM \"SPScanTool_GetAdmissionData_History\"(@Parm_PatientId,@Parm_LocationId,@Parm_ProviderID,@Parm_DateType,@Parm_StartDate,@Parm_EndDate)";

                    AdmissionDataHistory = _repository.Fetch<object>(
                        sqlQuery,
                        new
                        {
                            Parm_PatientId = PatientID,
                            Parm_LocationId = LocationID,
                            Parm_ProviderID = ProviderID,  // Notice the case change here
                            Parm_DateType = DateType,
                            Parm_StartDate = StartDate,
                            Parm_EndDate = EndDate
                        }
                    );

                    GC.Collect();
                    tx.Complete();
                }
                return AdmissionDataHistory;
            }
            catch (Exception ex)
            {
                log.Error("GetAdmissionData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }
        public List<object>? GetAdmissionData(int PatientID, int LocationID, int ProviderID, int DateType, string StartDate, string EndDate, int DischType)
        {
            List<object>? AdmissionData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string sqlQuery =
                        $"SELECT * FROM \"SPScanTool_GetAdmissionData\"(@Parm_PatientId,@Parm_LocationId,@Parm_ProviderID,@Parm_DateType,@Parm_StartDate,@Parm_EndDate,@parm_DischType)";

                    AdmissionData = _repository.Fetch<object>(
                        sqlQuery,
                        new
                        {
                            Parm_PatientId = PatientID,
                            Parm_LocationId = LocationID,
                            Parm_ProviderID = ProviderID,  // Notice the case change here
                            Parm_DateType = DateType,
                            Parm_StartDate = StartDate,
                            Parm_EndDate = EndDate,
                            parm_DischType = DischType
                        }
                    );

                    GC.Collect();
                    tx.Complete();
                }
                return AdmissionData;
            }
            catch (Exception ex)
            {
                log.Error("GetAdmissionData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }
        public List<object>? SearchedPatientsHistoryData(string SearchText, int ProviderId, int LocationId, int DateType, string StartDate, string EndDate)
        {

            List<object>? SearchedPatientsHistoryData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string searchTextParam = string.IsNullOrEmpty(SearchText)
                        ? "''"
                         : SearchText.Replace("'", "''");

                    string sqlQuery =
                        $"SELECT * FROM \"SPScanTool_GetSearchedPatients_History\"(@Parm_SearchText,@parm_ProviderId,@parm_LocationId,@parm_DateType,@parm_StartDate,@parm_EndDate)";
                    SearchedPatientsHistoryData = _repository.Fetch<object>(
                        sqlQuery,
                        new { Parm_SearchText = SearchText, parm_ProviderId = ProviderId, parm_LocationId = LocationId, parm_DateType = DateType, parm_StartDate = StartDate, parm_EndDate = EndDate}
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return SearchedPatientsHistoryData;
            }
            catch (Exception ex)
            {
                log.Error("SearchedPatientsData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }

        public List<object>? SearchedPatientsData(string SearchText, int ProviderId, int LocationId, int DateType, string StartDate, string EndDate, int DischType)
        {

            List<object>? SearchPatientsData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string searchTextParam = string.IsNullOrEmpty(SearchText)
                        ? "''"
                         : SearchText.Replace("'", "''");

                    string sqlQuery =
                        $"SELECT * FROM \"SPScanTool_GetSearchedPatients\"(@Parm_SearchText,@parm_ProviderId,@parm_LocationId,@parm_DateType,@parm_StartDate,@parm_EndDate,@parm_DischType )";
                    SearchPatientsData = _repository.Fetch<object>(
                        sqlQuery,
                        new { Parm_SearchText = SearchText, parm_ProviderId = ProviderId, parm_LocationId = LocationId, parm_DateType = DateType, parm_StartDate = StartDate, parm_EndDate = EndDate, parm_DischType = DischType }
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return SearchPatientsData;
            }
            catch (Exception ex)
            {
                log.Error("SearchedPatientsData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }
        
        public List<object>? LoadLocations(Boolean IsLoadAll,Boolean IsOldData)//int LocationId, 
        {
            List<object>? LoadLocationsData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {

                    string sqlQuery =
                        $"SELECT * FROM \"SPScanTool_LoadLocations\"(@Parm_LoadAll,@Param_IsOldData)";
                    LoadLocationsData = _repository.Fetch<object>(
                        sqlQuery,
                        new { Parm_LoadAll = IsLoadAll,Param_IsOldData =IsOldData } //Parm_LocationId = LocationId, 
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return LoadLocationsData;
            }
            catch (Exception ex)
            {
                log.Error("LoadLocationsData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }

        public List<object>? GetUserRights(int UserId) 
        {
            List<object>? UserRightsData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {

                    string sqlQuery =
                        $"SELECT * FROM \"SPScanTool_GetUserRights\"(@Parm_UserId)";
                    UserRightsData = _repository.Fetch<object>(
                        sqlQuery,
                        new { Parm_UserId = UserId } 
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return UserRightsData;
            }
            catch (Exception ex)
            {
                log.Error("UserRightsData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }

        public List<DocumentCategories>? DocumentCategories()
        {
            List<DocumentCategories>? DocumentCategoriesData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    DocumentCategoriesData = _repository.Fetch<DocumentCategories>(
                        "SELECT * FROM \"SPScanTool_LoadDocumentCategories\"()"
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return DocumentCategoriesData;
            }
            catch (Exception ex)
            {
                log.Error("DocumentCategories->Failed to get info from db - " + ex.Message);
                return null;
            }
        }
        public List<object>? GetProcedures()
        {
            List<object>? GetProceduresData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    GetProceduresData = _repository.Fetch<object>(
                        "SELECT * FROM \"SPScanTool_GetProcedures\"()"
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return GetProceduresData;
            }
            catch (Exception ex)
            {
                log.Error("GetProcedures ->Failed to get info from db - " + ex.Message);
                return null;
            }
        }
        // public List<ConfigValues>? ConfigValues(int CompanyId)
        // {
        //     List<ConfigValues>? ConfigValuesData = null;
        //     try
        //     {
        //         using (var tx = _repository.GetTransaction())
        //         {
        //             ConfigValuesData = _repository.Fetch<ConfigValues>(
        //                 "SELECT \"ID\", \"Environment\", \"RemotePath\", \"CompanyName\", \"FTPServiceURL\", \"DPI\", \"PDFSizeLimit\", \"DefaultDocType\", \"IsActive\" " +
        //                 "FROM \"ScanConfigMaster\" " +
        //                 "WHERE \"IsActive\" = TRUE " +
        //                 "ORDER BY \"CompanyName\""
        //             );
        //             GC.Collect();
        //             tx.Complete();
        //         }
        //         return ConfigValuesData;
        //     }
        //     catch (Exception ex)
        //     {
        //         log.Error("ConfigValues->Failed to get info from db - " + ex.Message);
        //         return null;
        //     }
        // }

        public string GetDatabaseNameFromConnectionString(string connectionString)
        {
            // Split connection string by ';'
            var parameters = connectionString.Split(';', StringSplitOptions.RemoveEmptyEntries);

            foreach (var param in parameters)
            {
                // Check if the parameter starts with 'Database=' (case-insensitive)
                if (param.StartsWith("Database=", StringComparison.OrdinalIgnoreCase))
                {
                    // Return the value after 'Database='
                    return param.Split('=')[1];
                }
            }

            // Return a default message if not found
            return "Database name not found!";
        }
        public List<object>? ConfigValues(int CompanyId, string StrConnection)
        {

            string DatabaseName = GetDatabaseNameFromConnectionString(StrConnection);

            List<object>? ConfigValuesData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    ConfigValuesData = _repository.Fetch<object>(
                        "SELECT '" + DatabaseName + "' AS \"DatabaseName\", * FROM \"SPScanTool_GetScanConfigByCompanyId\"(@0)", CompanyId
                    );

                    GC.Collect();
                    tx.Complete();
                }
                return ConfigValuesData;
            }
            catch (Exception ex)
            {
                log.Error("ConfigValues->Failed to get info from db - " + ex.Message);
                return null;
            }
        }


        public List<Specialities>? Specialities()
        {
            List<Specialities>? SpecialitiesData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    //"select \"SpecializationId\" as \"ID\", \"SpecializationName\" \"Name\" from \"Specialization\" WHERE \"Active\" = true ORDER BY \"Name\""
                    SpecialitiesData = _repository.Fetch<Specialities>(
                         "SELECT * FROM \"SPScanTool_LoadSpecialities\"()"
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return SpecialitiesData;
            }
            catch (Exception ex)
            {
                log.Error("Specialities->Failed to get info from db - " + ex.Message);
                return null;
            }
        }

        public List<object>? PatientDocuments(int SPatientID, int SLocationID,int SAppointmentID, int SAdmissionID, int SDocID, string? SDueFrom, string? SDueTO)
        {
            List<object>? PatientDocumentsData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string dueFromSql = string.IsNullOrWhiteSpace(SDueFrom) ? "NULL" : $"'{SDueFrom}'";
                    string dueToSql = string.IsNullOrWhiteSpace(SDueTO) ? "NULL" : $"'{SDueTO}'";

                    string sql = $@"
                SELECT * FROM ""SPScanTool_GetPatientDocuments""(
                    {SPatientID},
                    {SLocationID},
                    {SAppointmentID},
                    {SAdmissionID},
                    {SDocID},
                    {dueFromSql},
                    {dueToSql}
                );";

                    PatientDocumentsData = _repository.Fetch<object>(sql);
                    GC.Collect();
                    tx.Complete();
                }
                return PatientDocumentsData;
            }
            catch (Exception ex)
            {
                log.Error("PatientDocuments->Failed to get info from db - " + ex.Message);
                return null;
            }
        }


        public List<Admissions>? PatientAdmissions(int SPatientID)
        {
            List<Admissions>? PatientAdmissions = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    PatientAdmissions = _repository.Fetch<Admissions>(
                        "SELECT * FROM \"SPScanTool_LoadAdmissions\"("
                            + SPatientID.ToString()
                            + ");"
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return PatientAdmissions;
            }
            catch (Exception ex)
            {
                log.Error("PatientAdmissions->Failed to get info from db - " + ex.Message);
                return null;
            }
        }

        public List<object>? AdmissionDischargeData(int SndAdmissionId,int SndIsOldData)
        {
            List<object>? AdmissionDischargeData = null;
            try
            {
                using (var tx = _repository.GetTransaction())
                {

                    string sqlQuery =
                        $"SELECT * FROM \"SPScanTool_GetAdmissionDischargeData\"(@Parm_AdmissionId,@Parm_IsOldData)";
                    AdmissionDischargeData = _repository.Fetch<object>(
                        sqlQuery,
                        new { Parm_AdmissionId = SndAdmissionId,Parm_IsOldData = SndIsOldData }
                    );
                    GC.Collect();
                    tx.Complete();
                }
                return AdmissionDischargeData;
            }
            catch (Exception ex)
            {
                log.Error("AdmissionDischargeData->Failed to get info from db - " + ex.Message);
                return null;
            }
        }
        public int SaveAdmissionDischargeData(List<AdmissionDischargeModel> models)
        {
            int savedCount = 0;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string SQLStr = "SELECT public.\"SPScanTool_SaveAdmissionDischargeData\"(@MRDId, @PatientId, @AdmissionId, @ProviderId, " +
                                    "@LocationId, @DepartmentId, @AdmissionAge, @AdmissionDate, @AdmissionTypeId, @DischargeDate, " +
                                    "@DischargeType, @Cause, @UserId, @IsWardChanged, @IsICDChanged, @IsProcChanged, " +
                                    "@Wards::jsonb, @ICDCodes::jsonb, @Procedures::jsonb, @MRD_Diagnosis,@MRD_OtherProcedures,@Parm_IsOldData)"; // Explicitly cast JSON to jsonb @MRD_Diagnosis::jsonb

                    foreach (var model in models)
                    {
                        var parameters = new
                        {
                            MRDId = model.MRDId,
                            PatientId = model.PatientId,
                            AdmissionId = model.AdmissionId,
                            ProviderId = model.ProviderId,
                            LocationId = model.LocationId,
                            DepartmentId = model.DepartmentId,
                            AdmissionAge = model.AdmissionAge,
                            AdmissionDate = model.AdmissionDate?.ToString("yyyy-MM-dd HH:mm:ss") ?? (object)DBNull.Value, // Null safety
                            AdmissionTypeId = model.AdmissionTypeId,
                            DischargeDate = model.DischargeDate?.ToString("yyyy-MM-dd HH:mm:ss") ?? (object)DBNull.Value, // Null safety
                            //DischargeTypeId = model.DischargeTypeId,
                            DischargeType = model.DischargeType,
                            Cause = string.IsNullOrEmpty(model.Cause) ? (object)DBNull.Value : model.Cause, // Handle null
                            UserId = model.UserId,
                            IsWardChanged = model.IsWardChanged,
                            IsICDChanged = model.IsICDChanged,
                            IsProcChanged = model.IsProcChanged,
                            Wards = model.Wards != null ? JsonConvert.SerializeObject(model.Wards) : (object)DBNull.Value, // Convert to JSON string
                            ICDCodes = model.ICDCodes != null ? JsonConvert.SerializeObject(model.ICDCodes) : (object)DBNull.Value,
                            Procedures = model.Procedures != null ? JsonConvert.SerializeObject(model.Procedures) : (object)DBNull.Value,
                            MRD_Diagnosis = string.IsNullOrEmpty(model.Diagnosis) ? (object)DBNull.Value : model.Diagnosis.ToString(),
                            MRD_OtherProcedures = string.IsNullOrEmpty(model.MRD_OtherProcedures) ? (object)DBNull.Value : model.MRD_OtherProcedures.ToString(),
                            Parm_IsOldData = model.IsOldData
                        };

                        savedCount += _repository.Single<int>(SQLStr, parameters);
                    }

                    tx.Complete();
                }
            }
            catch (Npgsql.PostgresException pgEx)
            {
                log.Error($"PostgreSQL Error in SaveAdmissionDischargeData -> Code: {pgEx.SqlState}, Message: {pgEx.Message}", pgEx);
            }
            catch (Exception ex)
            {
                log.Error($"SaveAdmissionDischargeData -> Failed to execute query - Error: {ex.Message}", ex);
            }

            return savedCount;
        }


        public int SavePatientDocumentData(List<PatientDocumentDetailsModel> patientDocs)
        {
            int savedCount = 0;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    foreach (var doc in patientDocs)
                    {
                        string SQLStr = "SELECT * FROM \"SPScanTool_SavePatientDocument\"(@PatDocId, @UploadedDate, @PatientId, @UploadedBy, " +
                                        "@DocumentName, @DocumentType, @ContentType, @Size, @Description, @DocumentUrl, @ThumbnailUrl,@SortNo, @SplID, @AdmissionID,@Parm_IsOldData)";

                        var parameters = new
                        {
                            PatDocId = doc.PatDocId,
                            UploadedDate = doc.UploadedDate, // Ensure valid date format if needed
                            PatientId = doc.PatientId,
                            UploadedBy = doc.UploadedBy,
                            DocumentName = doc.DocumentName,
                            DocumentType = doc.DocumentType,
                            ContentType = doc.ContentType,
                            Size = doc.Size,  // Ensure string is handled correctly
                            Description = doc.Description,
                            DocumentUrl = doc.DocumentUrl,
                            ThumbnailUrl = doc.ThumbnailUrl,
                            SortNo = doc.SortNo,
                            SplID = doc.SplID,
                            AdmissionID = doc.AdmissionID,
                            Parm_IsOldData =doc.IsOldData
                        };

                        _repository.Single<int>(SQLStr, parameters);
                        savedCount++;
                    }
                    tx.Complete();
                }
            }
            catch (Exception ex)
            {
                log.Error("SaveMultiplePatientDocuments -> Failed to save records - Error: " + ex.Message);
            }
            return savedCount;
        }

        public int UpdateImageCategory(int sndPatDocId, int sndDocTypeId, int sndUserID)
        {
            int savedCount = 0;
            try
            {
                using (var tx = _repository.GetTransaction())
                {

                    string SQLStr = "SELECT * FROM \"SPScanTool_UpdateImageCategory\"(@PatDocId, @DocTypeId, @UserID)";

                    var parameters = new
                    {
                        PatDocId = sndPatDocId,
                        DocTypeId = sndDocTypeId, // Ensure valid date format if needed
                        UserID = sndUserID
                    };

                    _repository.Single<int>(SQLStr, parameters);
                    savedCount++;
                    tx.Complete();
                }
            }
            catch (Exception ex)
            {
                log.Error("UpdateImageCategory -> Failed to save records - Error: " + ex.Message);
            }
            return savedCount;
        }
        public int UpdateImageSortNo(PatientImgDocSort model)
        {
            int savedCount = 0;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string SQLStr = "SELECT * FROM public.\"SPScanTool_UpdateImageSortNo\"(@Parm_SortData::jsonb)";

                    var parameters = new
                    {
                        Parm_SortData = model != null
                            ? JsonConvert.SerializeObject(model)
                            : "[]"
                    };

                    _repository.Single<int>(SQLStr, parameters);
                    savedCount++;
                    tx.Complete();
                }
            }
            catch (Exception ex)
            {
                log.Error("UpdateImageSortNo -> Failed to save records - Error: " + ex.Message);
            }
            return savedCount;
        }


        // public int SavePatientDocumentData_bkp(PatientDocumentDetailsModel SndPatDocRec)
        // {
        //     int _save = 0;
        //     try
        //     {
        //         using (var tx = _repository.GetTransaction())
        //         {
        //             string SQLStr =
        //                 "SELECT * FROM \"SPScanTool_SavePatientDocument\"("
        //                  + SndPatDocRec.PatDocId
        //                  + ",'"
        //                 + SndPatDocRec.UploadedDate
        //                 + "',"
        //                 + SndPatDocRec.PatientId
        //                 + ","
        //                 + SndPatDocRec.UploadedBy
        //                 + ",'"
        //                 + SndPatDocRec.DocumentName
        //                 + "','"
        //                 + SndPatDocRec.DocumentType
        //                 + "','"
        //                 + SndPatDocRec.ContentType
        //                 + "',"
        //                 + SndPatDocRec.Size
        //                 + ",'"
        //                 + SndPatDocRec.Description
        //                 + "','"
        //                 + SndPatDocRec.DocumentUrl
        //                 + "','"
        //                 + SndPatDocRec.ThumbnailUrl
        //                 + "',"
        //                 + SndPatDocRec.SplID
        //                 + ","
        //                 + SndPatDocRec.AdmissionID
        //                 + ")";
        //             _save = _repository.Single<int>(SQLStr);
        //             GC.Collect();
        //             tx.Complete();
        //         }
        //     }
        //     catch (Exception ex)
        //     {
        //         log.Error("SavePatientDocumentData->Failed to get info from db - " + ex.Message);
        //     }
        //     return _save;
        // }

        // public int DeletePatientDocumentData(int SndPatDocRecID)
        // {
        //     int _Delete = 0;
        //     try
        //     {
        //         using (var tx = _repository.GetTransaction())
        //         {
        //             string SQLStr =
        //                 "SELECT * FROM \"SPScanTool_DeletePatientDocument\"("
        //                 + SndPatDocRecID
        //                 + ");";
        //             _Delete = _repository.Single<int>(SQLStr);
        //             GC.Collect();
        //             tx.Complete();
        //         }
        //     }
        //     catch (Exception ex)
        //     {
        //         log.Error("DeletePatientDocumentData->Failed to get info from db - " + ex.Message);
        //     }
        //     return _Delete;
        // }

        public string DeletePatientDocumentData(int SndAdmissionId,int SndPatDocRecID, int SndUserID,int SndIsOldData)
        {
            string result = string.Empty;
            try
            {
                using (var tx = _repository.GetTransaction())
                {
                    string SQLStr =
                        "SELECT * FROM \"SPScanTool_DeletePatientDocument\"("
                        + SndAdmissionId + ',' + SndPatDocRecID + ',' + SndUserID + ','+ SndIsOldData
                        + ");";

                    result = _repository.Single<string>(SQLStr);
                    result = "";

                    GC.Collect();
                    tx.Complete();
                }
            }
            catch (Exception ex)
            {
                log.Error("DeletePatientDocumentData->Failed to get info from db - " + ex.Message);
                result = "Error: " + ex.Message;
            }
            return result;
        }

        public bool IsValidUserData(string SndUserName, string SndPassword)
        {
            try
            {
                int count = 0;
                using (var tx = _repository.GetTransaction())
                {
                    count = _repository.Single<int>(
                        "SELECT COUNT(*) as \"RecordCount\" FROM \"Login\" WHERE \"Username\" = '"
                            + SndUserName
                            + "' AND \"Password\" = '"
                            + SndPassword
                            + "'"
                    );
                    GC.Collect();
                    tx.Complete();
                }
                if (count > 0)
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {
                log.Error("IsValidUserData->Failed to get info from db - " + ex.Message);
                return false;
            }
        }
    }
}
