using System;
using System.Collections.Generic;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.Linq;
using System.Net;
using System.Runtime.InteropServices;
using System.Security.Cryptography;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Threading.Tasks;
using FTP_Services.Core.Models;
using FTP_Services.Services;
using iTextSharp.text.pdf;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Options;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace FTP_Services.Services.Controllers
{
    public class FTPManagementAPIController : BaseAPIController
    {
        private readonly AppSettings _appSettings;
        private readonly Microsoft.AspNetCore.Hosting.IWebHostEnvironment _hostingEnvironment;

        // public FTPManagementAPIController(
        //     IOptions<AppSettings> appSettings,
        //     IConfiguration configuration,
        //     Microsoft.AspNetCore.Hosting.IWebHostEnvironment hostingEnvironment
        // )
        //     : base(appSettings.Value)
        public FTPManagementAPIController(IOptions<AppSettings> appSettings)
            : base(appSettings.Value)
        {
            log.Info("FTPManagementAPIController : Constractor");
            _appSettings = appSettings.Value;
            //  _hostingEnvironment = hostingEnvironment;
        }

        [HttpPost("GetLoginDetails")]
        public IActionResult GetLoginDetails([FromBody] LoginResponseModel model)
        {
            // _hostingEnvironment.log("GetLoginDetails  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<Object>? RequestsList = adapter.LoginData(model.UserName);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for login - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetSearchedHistoryPatients")]
        public IActionResult GetSearchedHistoryPatients(string SearchText, int ProviderId, int LocationId, int DateType, string StartDate, string EndDate)
        {
            log.Debug("GetSearchedPatients  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                // List<SearchPatients>? RequestsList = adapter.SearchedPatientsData(SearchText);
                List<object>? RequestsList = adapter.SearchedPatientsHistoryData(SearchText, ProviderId, LocationId, DateType, StartDate, EndDate);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for search patients - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetSearchedPatients")]
        public IActionResult GetSearchedPatients(string SearchText, int ProviderId, int LocationId, int DateType, string StartDate, string EndDate, int DischType)
        {
            log.Debug("GetSearchedPatients  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                // List<SearchPatients>? RequestsList = adapter.SearchedPatientsData(SearchText);
                List<object>? RequestsList = adapter.SearchedPatientsData(SearchText, ProviderId, LocationId, DateType, StartDate, EndDate, DischType);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for search patients - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetAdmissionDataHistory")]
        public IActionResult GetAdmissionDataHistory(int PatientID, int LocationID, int ProviderID, int DateType, string StartDate, string EndDate, int RecType)
        {
            log.Debug("GetAdmissionDataHistory  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetAdmissionDataHistory(PatientID, LocationID, ProviderID, DateType, StartDate, EndDate, RecType);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for GetAdmissionDataHistory - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetAdmissionData")]
        public IActionResult GetAdmissionData(int PatientID, int LocationID, int ProviderID, int DateType, string StartDate, string EndDate, int DischType)
        {
            log.Debug("GetAdmissionData  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetAdmissionData(PatientID, LocationID, ProviderID, DateType, StartDate, EndDate, DischType);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for Admissions - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("LoadPhysicians")]
        public IActionResult GetLoadPhysicians(int LocationId, int RecType)
        {
            log.Debug("LoadPhysicians  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GeLoadPhysicians(LocationId, RecType);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for GetLoadPhysicians - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetUserRights")]
        public IActionResult GetUserRights(int UserId)
        {
            log.Debug("GetUserRights ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetUserRights(UserId);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for GetUserRights - Error:" + ex.Message);
                return NotFound("No results");
            }
        }
        [HttpGet("GetLocations")]
        public IActionResult GetLocations(Boolean IsLoadAll, int RecType) //int LocationId, 
        {
            log.Debug("GetLocations  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.LoadLocations(IsLoadAll, RecType);//LocationId, 
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for GetLocations - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        private async Task<bool> FileExistsAsync(string fileUrl, string username, string password)
        {
            try
            {
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(fileUrl);
                request.Credentials = new NetworkCredential(username, password);
                request.Method = WebRequestMethods.Ftp.GetFileSize;
                request.Timeout = 2400000; // Increased timeout
                request.ReadWriteTimeout = 2400000; // Increased read/write timeout

                using (FtpWebResponse response = (FtpWebResponse)await request.GetResponseAsync())
                {
                    return response.StatusCode == FtpStatusCode.FileStatus;
                }
            }
            catch (WebException ex)
            {
                if (ex.Response is FtpWebResponse response)
                {
                    if (response.StatusCode == FtpStatusCode.ActionNotTakenFileUnavailable)
                    {
                        // File does not exist
                        return false;
                    }
                    response.Close();
                }
                throw; // Rethrow other exceptions
            }
        }

        private async Task DeleteFileAsync(string fileUrl, string username, string password)
        {
            try
            {
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(fileUrl);
                request.Credentials = new NetworkCredential(username, password);
                request.Method = WebRequestMethods.Ftp.DeleteFile;
                request.Timeout = 2400000; // Increased timeout
                request.ReadWriteTimeout = 2400000; // Increased read/write timeout

                using (FtpWebResponse response = (FtpWebResponse)await request.GetResponseAsync())
                {
                    // If file deletion is successful, status code will be 'FileActionOK'
                    if (response.StatusCode != FtpStatusCode.FileActionOK)
                    {
                        // throw new InvalidOperationException("Failed to delete file: {response.StatusDescription}");
                    }
                }
            }
            catch (WebException ex)
            {
                if (ex.Response is FtpWebResponse response)
                {
                    // Log the status code if file deletion fails
                    // Console.WriteLine(
                    //     $"Error: {response.StatusCode} - {response.StatusDescription}"
                    // );
                    response.Close();
                }
                // Rethrow the exception so calling code can handle it
                // throw new InvalidOperationException("Failed to delete file", ex);
            }
        }

        [HttpGet("LoadDocumentCategories")]
        public IActionResult LoadDocumentCategories()
        {
            log.Debug("LoadDocumentCategories  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<DocumentCategories>? RequestsList = adapter.DocumentCategories();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for load documents - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetProcedures")]
        public IActionResult GetProcedures()
        {
            log.Debug("GetProcedures  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetProcedures();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for load documents - Error:" + ex.Message);
                return NotFound("No results");
            }
        }


        [HttpGet("LoadDocumentTypes")]
        public IActionResult LoadDocumentTypes()
        {
            log.Debug("LoadDocumentTypes  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.LoadDocumentTypes();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for LoadDocumentTypes - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetConfigValues")]
        public IActionResult GetConfigValues(int CompanyId)
        {
            log.Debug("GetConfigValues  ==> ");
            try
            {
                string DatabaseName = _appSettings.ConnectionString;
                _appSettings.ConnectionString = _appSettings.AdminConnectionString;
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.ConfigValues(CompanyId, DatabaseName);
                _appSettings.ConnectionString = DatabaseName;
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for GetConfigValues - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetSpecialities")]
        public IActionResult GetSpecialities()
        {
            log.Debug("GetSpecialities  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<Specialities>? RequestsList = adapter.Specialities();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for specialities - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetPatientDocuments")]
        public IActionResult GetPatientDocuments(int SPatientID, int SLocationID, int SAppointmentID, int SAdmissionID, int SDocID, string SDueFrom, string SDueTO)
        {
            log.Debug("GetPatientDocuments  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.PatientDocuments(SPatientID, SLocationID, SAppointmentID, SAdmissionID, SDocID, SDueFrom, SDueTO);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for patient documents - Error:" + ex.Message);
                return NotFound("No results");
            }
        }
        [HttpGet("GetDocumentYears")]
        public IActionResult GetDocumentYears(int Parm_DType)
        {
            log.Debug("GetDocumentYears  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetDocumentYears(Parm_DType);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for patient documents - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetPatientAdmissions")]
        public IActionResult GetPatientAdmissions(int SPatientID)
        {
            log.Debug("GetPatientAdmissions  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<Admissions>? RequestsList = adapter.PatientAdmissions(SPatientID);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for patient documents - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetAdmissionDischargeData")]
        public IActionResult GetAdmissionDischargeData(int SndAdmissionID, int SndRecType)
        {
            log.Debug("GetPatientAdmissions  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.AdmissionDischargeData(SndAdmissionID, SndRecType);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get GetAdmissionDischargeData - Error:" + ex.Message);
                return NotFound("No results");
            }
        }


        [HttpPost("UpdateImageCategory")]
        public int UpdateImageCategory(int sndPatDocId, int sndDocTypeId, int sndUserID)
        {
            int savedCount = 0;
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                savedCount = adapter.UpdateImageCategory(sndPatDocId, sndDocTypeId, sndUserID);
            }
            catch (Exception ex)
            {
                log.Error("UpdateImageCategory -> Failed to save documents - Error: " + ex.Message);
            }
            return savedCount;
        }

        [HttpPost("UpdateImageSortNo")]
        public int UpdateImageSortNo([FromBody] PatientImgDocSort PatImgDoc)
        {
            int savedCount = 0;
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                savedCount = adapter.UpdateImageSortNo(PatImgDoc);
            }
            catch (Exception ex)
            {
                log.Error("UpdateImageSortNo -> Failed to save documents - Error: " + ex.Message);
            }
            return savedCount;
        }


        [HttpPost("SavePatientDocument")]
        public int SavePatientDocumentData([FromBody] List<PatientDocumentDetailsModel> models)
        {
            log.Debug("SaveMultiplePatientDocuments  ==> Received " + models.Count + " records.");
            int savedCount = 0;
            try
            {
                if (models == null || models.Count == 0)
                {
                    log.Warn("SaveMultiplePatientDocuments => No data received.");
                    return 0;
                }

                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                savedCount = adapter.SavePatientDocumentData(models);
            }
            catch (Exception ex)
            {
                log.Error("SaveMultiplePatientDocuments -> Failed to save documents - Error: " + ex.Message);
            }
            return savedCount;
        }

        [HttpPost("SaveAdmissionDischargeData")]
        public IActionResult SaveAdmissionDischargeData([FromBody] List<AdmissionDischargeModel> models)
        {
            if (models == null || models.Count == 0)
            {
                log.Warn("SaveAdmissionDischargeData => No data received.");
                return BadRequest("No data received.");
            }

            log.Debug("SaveAdmissionDischargeData ==> Received " + models.Count + " records.");

            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                int savedCount = adapter.SaveAdmissionDischargeData(models);

                log.Info($"SaveAdmissionDischargeData => Successfully saved {savedCount} records.");
                return Ok(savedCount);
            }
            catch (Exception ex)
            {
                log.Error("SaveAdmissionDischargeData -> Failed to save data - " + ex.Message);
                return StatusCode(500, "Internal server error");
            }


        }

        [HttpGet("GetUserLocations")]
        public IActionResult GetUserLocations(string sndUserName)
        {
            log.Debug("GetLocations  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetUserLocations(sndUserName);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data  GetUserLocations - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetDepartments")]
        public IActionResult GetDepartments(int sndLocationId)
        {
            log.Debug("GetLocations  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetDepartments(sndLocationId);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data  GetDepartments - Error:" + ex.Message);
                return NotFound("No results");
            }
        }
        [HttpGet("GetWards")]
        public IActionResult GetWards(int sndLocationId)
        {
            log.Debug("GetWards  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetWards(sndLocationId);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data  GetWards - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetAdmissionTypes")]
        public IActionResult GetAdmissionTypes()
        {
            log.Debug("GetAdmissionTypes  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetAdmissionTypes();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data  GetAdmissionTypes - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetDischargeTypes")]
        public IActionResult GetDischargeTypes()
        {
            log.Debug("GetDischargeTypes  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetDischargeTypes();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data  GetDischargeTypes - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("LoadICD")]
        public IActionResult LoadICD()
        {
            log.Debug("LoadICD  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.LoadICD();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data  LoadICD - Error:" + ex.Message);
                return NotFound("No results");
            }
        }


        [HttpPost("DeletePatientDocument")]
        public string DeletePatientDocument(int AdmissionId, int DocumentID, int UserID, int SndRecType)
        {
            log.Debug("DeletePatientDocument  ==> ");
            string DeletePT = "";
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                DeletePT = adapter.DeletePatientDocumentData(AdmissionId, DocumentID, UserID, SndRecType);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for delete patient documents - Error:" + ex.Message);
            }
            return DeletePT;
        }

        [HttpGet("IsValidUser")]
        public bool IsValidUser(string SndUserName, string SndPassword)
        {
            log.Debug("IsValidUser  ==> ");
            bool _isValid = false;
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                _isValid = adapter.IsValidUserData(SndUserName, SndPassword);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for IsValidUser - Error:" + ex.Message);
            }
            return _isValid;
        }

        [HttpPost("DownloadBase64DataAsync")]
        public async Task<string> DownloadBase64DataAsync(string fileNameWithPath, bool IsExternal)
        {
            bool isFTPMODE = _appSettings.FTPConfiguration.FTPMODE;
            var base64 = string.Empty;
            if (IsExternal == true)
            {
                int bytesRead;
                // byte[] buffer = new byte[2048];
                byte[] buffer = new byte[1048576]; // 1 MB buffer
                byte[] fileData = null;

                string FTPURL = _appSettings.FTPConfiguration.FtpURL.ToString() + '/' + _appSettings.FTPConfiguration.DestinationPathFtp.ToString();
                string FTPUserName = _appSettings.FTPConfiguration.Username.ToString();
                string FTPPassword = _appSettings.FTPConfiguration.Password.ToString();

                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(FTPURL + fileNameWithPath);
                request.Method = WebRequestMethods.Ftp.DownloadFile;
                request.Credentials = new NetworkCredential(FTPUserName, FTPPassword);
                try
                {
                    Stream reader = request.GetResponse().GetResponseStream();
                    using (MemoryStream ms = new MemoryStream())
                    {
                        while (true)
                        {
                            bytesRead = await reader.ReadAsync(buffer, 0, buffer.Length);
                            if (bytesRead == 0)
                                break;
                            ms.Write(buffer, 0, bytesRead);
                        }
                        fileData = ms.ToArray();
                    }
                    reader.Close();
                    base64 = Convert.ToBase64String(fileData);
                }
                catch (WebException ex)
                {
                    FtpWebResponse response = (FtpWebResponse)ex.Response;
                    if (response.StatusCode == FtpStatusCode.ActionNotTakenFileUnavailable)
                    {
                        response.Close();
                    }
                    return null;
                }
            }
            else
            {
                string strDestinationPath = _appSettings
                    .FTPConfiguration.DestinationPathFile.ToString()
                    .Trim();
                string strFullPath = Path.Combine(strDestinationPath, fileNameWithPath);
                if (string.IsNullOrEmpty(strFullPath) || !System.IO.File.Exists(strFullPath))
                {
                    return "File not found";
                }

                byte[] fileBytes = await System.IO.File.ReadAllBytesAsync(strFullPath);
                base64 = Convert.ToBase64String(fileBytes);
            }
            return base64;
        }

        [HttpPost("DownloadBase64DataAsync_New")]
        public IActionResult DownloadBase64DataAsync_New(string fileNameWithPath)
        {
            string strDestinationPath = _appSettings.FTPConfiguration.DestinationPathFile.ToString().Trim();
            string strMfN = fileNameWithPath.Replace("/", "\\").TrimStart('\\');
            string strFullPath = Path.Combine(strDestinationPath, strMfN);

            if (string.IsNullOrEmpty(strFullPath) || !System.IO.File.Exists(strFullPath))
            {
                return BadRequest("File not found");
            }

            try
            {
                var fileStream = new FileStream(strFullPath, FileMode.Open, FileAccess.Read, FileShare.Read);
                var base64Stream = new Base64EncodingStream(fileStream);
                return new FileStreamResult(base64Stream, "application/octet-stream")
                {
                    FileDownloadName = Path.GetFileName(fileNameWithPath)
                };
            }
            catch (Exception ex)
            {
                return StatusCode(500, "Error processing file: " + ex.Message.ToString());
            }
        }

        [HttpGet("GetPDFBase64")]
        public async Task<string> GetPDFBase64(string remoteFilePath)
        {
            // string filePath = @"C:\Users\mohank\Desktop\FTP\9.pdf";
            byte[] fileBytes = System.IO.File.ReadAllBytes(remoteFilePath);

            string strbase64 = Convert.ToBase64String(fileBytes);
            return strbase64;
        }

        [HttpPost("DownloadBase64LargeFileAsync")]
        public async Task<string> DownloadBase64LargeFileAsync(string remoteFilePath)
        {
            // string filePath = @"C:\Users\mohank\Desktop\FTP\9.pdf";
            // byte[] fileBytes = System.IO.File.ReadAllBytes(filePath);
            // string strbase64=Convert.ToBase64String(fileBytes);
            // return strbase64;

            try
            {
                string _ftpUrl = _appSettings.FTPConfiguration.FtpURL.ToString();
                string _ftpUsername = _appSettings.FTPConfiguration.Username.ToString();
                string _ftpPassword = _appSettings.FTPConfiguration.Password.ToString();

                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(_ftpUrl + remoteFilePath);
                request.Method = WebRequestMethods.Ftp.DownloadFile;
                request.Credentials = new NetworkCredential(_ftpUsername, _ftpPassword);
                request.UseBinary = true;
                request.UsePassive = true;
                request.KeepAlive = true;
                request.Timeout = 2400000; // Increased timeout for large files (40 minutes)
                request.ReadWriteTimeout = 2400000; // Increased read/write timeout for large files

                using (FtpWebResponse response = (FtpWebResponse)await request.GetResponseAsync())
                {
                    using (Stream ftpStream = response.GetResponseStream())
                    {
                        // byte[] buffer = new byte[1024 * 8];
                        byte[] buffer = new byte[1048576]; // 1 MB buffer
                        int bytesRead;
                        using (MemoryStream memoryStream = new MemoryStream())
                        {
                            while (
                                (bytesRead = await ftpStream.ReadAsync(buffer, 0, buffer.Length))
                                > 0
                            )
                            {
                                await memoryStream.WriteAsync(buffer, 0, bytesRead);
                            }
                            byte[] fileData = memoryStream.ToArray();
                            string base64Encoded = Convert.ToBase64String(fileData);
                            return base64Encoded;
                        }
                    }
                }
            }
            catch (WebException ex)
            {
                return ex.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        [HttpPost("RenameFtpFile")]
        public async Task<bool> RenameFtpFile(string source, string destination)
        {
            string FTPURL = _appSettings.FTPConfiguration.FtpURL.ToString();
            string FTPUserName = _appSettings.FTPConfiguration.Username.ToString();
            string FTPPassword = _appSettings.FTPConfiguration.Password.ToString();

            Uri serverFile = new Uri(FTPURL + source);
            FtpWebRequest request = (FtpWebRequest)WebRequest.Create(serverFile);
            request.Method = WebRequestMethods.Ftp.Rename;
            request.UseBinary = true;
            request.Credentials = new NetworkCredential(FTPUserName, FTPPassword);
            request.RenameTo = "/" + destination;
            FtpWebResponse response = (FtpWebResponse)request.GetResponse();
            var success =
                response.StatusCode == FtpStatusCode.CommandOK
                || response.StatusCode == FtpStatusCode.FileActionOK;
            return success;
        }

        //Using for Scan upload

        [HttpPost("UploadProfileImageAsync")]
        public async Task<string> UploadProfileImageAsync(
            [FromBody] FileResponseModel model,
            string filePath
        )
        {
            if (string.IsNullOrEmpty(filePath) && string.IsNullOrEmpty(model.Base64String))
            {
                return "Should not be empty filePath and file..";
            }
            var imageBytes = ToImageBytes(model.Base64String);
            var imageStream = new MemoryStream(imageBytes);

            bool isFTPMODE = _appSettings.FTPConfiguration.FTPMODE;
            string uploadResponse = string.Empty;
            if (isFTPMODE == true)
            {
                uploadResponse = await this.UploadFileWithStreamAsync(
                    filePath.ToString().Trim(),
                    imageStream
                );
            }
            else
            {
                uploadResponse = await this.UploadFileWithStreamLocal(
                    filePath.ToString().Trim(),
                    imageStream
                );

                // uploadResponse = await this.UploadFileWithStreamToNetworkShare(
                //     filePath.ToString().Trim(),
                //     imageStream
                // );
            }
            return uploadResponse;
        }

        [HttpPost("UploadLargeFileWithStreamLocal")]
        public async Task<string> UploadLargeFileWithStreamLocal(string fileName, Stream stream)
        {
            if (stream == null)
            {
                throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
            }

            if (string.IsNullOrWhiteSpace(fileName))
            {
                throw new ArgumentNullException(
                    nameof(fileName),
                    "File name cannot be null or empty."
                );
            }

            string strDestinationPath = _appSettings
                .FTPConfiguration.DestinationPathFile.ToString()
                .Trim();
            string strMfN = fileName.Replace("/", "\\").TrimStart('\\');

            string strFullPath = Path.Combine(strDestinationPath, strMfN);
            string strDirectoryPath = Path.GetDirectoryName(strFullPath);

            // Ensure the directory exists
            if (!Directory.Exists(strDirectoryPath))
            {
                Directory.CreateDirectory(strDirectoryPath);
            }

            // If file already exists, delete it
            if (System.IO.File.Exists(strFullPath))
            {
                try
                {
                    System.GC.Collect();
                    System.IO.File.Delete(strFullPath);
                }
                catch (Exception ex)
                {
                    return "Error deleting existing file: " + ex.Message;
                }
            }

            string filePath = Path.Combine(strDirectoryPath, Path.GetFileName(strFullPath));

            const int bufferSize = 1048576; // 80 KB buffer, you can adjust the size based on your system
            byte[] buffer = new byte[bufferSize];

            try
            {
                using (var fileStream = new FileStream(filePath, FileMode.Create, FileAccess.Write))
                {
                    int bytesRead;
                    while ((bytesRead = await stream.ReadAsync(buffer, 0, buffer.Length)) > 0)
                    {
                        await fileStream.WriteAsync(buffer, 0, bytesRead);
                    }
                }
                return string.Empty;
            }
            catch (Exception ex)
            {
                return "Error uploading file: " + ex.Message;
            }
        }

        [HttpPost("UploadFileByPath")]
        public async Task<string> UploadFileByPath(string filePath)
        {
            if (string.IsNullOrWhiteSpace(filePath))
            {
                throw new ArgumentNullException(
                    nameof(filePath),
                    "File path cannot be null or empty."
                );
            }

            if (!System.IO.File.Exists(filePath))
            {
                throw new FileNotFoundException("The specified file does not exist.", filePath);
            }

            string strDestinationPath = _appSettings
                .FTPConfiguration.DestinationPathFile.ToString()
                .Trim();
            string strMfN = Path.GetFileName(filePath);
            string strFullPath = Path.Combine(strDestinationPath, strMfN);
            string strDirectoryPath = Path.GetDirectoryName(strFullPath);

            if (!Directory.Exists(strDirectoryPath))
            {
                Directory.CreateDirectory(strDirectoryPath);
            }

            if (System.IO.File.Exists(strFullPath))
            {
                try
                {
                    System.GC.Collect();
                    System.IO.File.Delete(strFullPath);
                }
                catch (Exception ex)
                {
                    return "Error deleting existing file: " + ex.Message;
                }
            }
            const int bufferSize = 81920;
            byte[] buffer = new byte[bufferSize];

            try
            {
                using (var sourceStream = new FileStream(filePath, FileMode.Open, FileAccess.Read))
                using (
                    var destinationStream = new FileStream(
                        strFullPath,
                        FileMode.Create,
                        FileAccess.Write
                    )
                )
                {
                    int bytesRead;
                    while ((bytesRead = await sourceStream.ReadAsync(buffer, 0, buffer.Length)) > 0)
                    {
                        await destinationStream.WriteAsync(buffer, 0, bytesRead);
                    }
                }
                return string.Empty;
            }
            catch (Exception ex)
            {
                return "Error uploading file: " + ex.Message;
            }
        }

        public async Task<string> UploadFileWithStreamLocal(string fileName, Stream stream)
        {
            if (stream == null)
            {
                throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
            }

            if (string.IsNullOrWhiteSpace(fileName))
            {
                throw new ArgumentNullException(
                    nameof(fileName),
                    "File name cannot be null or empty."
                );
            }

            string strDestinationPath = _appSettings
                .FTPConfiguration.DestinationPathFile.ToString()
                .Trim();
            string strMfN = fileName.Replace("/", "\\").TrimStart('\\');

            string strFullPath = Path.Combine(strDestinationPath, strMfN);
            string strDirectoryPath = Path.GetDirectoryName(strFullPath);

            if (!Directory.Exists(strDirectoryPath))
            {
                Directory.CreateDirectory(strDirectoryPath);
            }

            if (System.IO.File.Exists(strFullPath))
            {
                try
                {
                    System.GC.Collect();
                    // System.GC.WaitForPendingFinalizers();
                    System.IO.File.Delete(strFullPath);
                }
                catch (Exception ex)
                {
                    return "Error deleting existing file: " + ex.Message.ToString();
                }
            }

            string filePath = Path.Combine(strDirectoryPath, Path.GetFileName(strFullPath));

            try
            {
                using (var fileStream = new FileStream(filePath, FileMode.Create, FileAccess.Write))
                {
                    await stream.CopyToAsync(fileStream);
                }
                return string.Empty;
            }
            catch (Exception ex)
            {
                return ex.Message.ToString();
            }
        }

        [HttpPost("UploadFileWithFilePath")]
        public async Task<string> UploadFileWithFilePath(string fileName, string filePath)
        {
            if (string.IsNullOrWhiteSpace(filePath))
            {
                throw new ArgumentNullException(
                    nameof(filePath),
                    "File path cannot be null or empty."
                );
            }

            if (string.IsNullOrWhiteSpace(fileName))
            {
                throw new ArgumentNullException(
                    nameof(fileName),
                    "File name cannot be null or empty."
                );
            }

            string strDestinationPath = _appSettings
                .FTPConfiguration.DestinationPathFile.ToString()
                .Trim();
            string strMfN = fileName.Replace("/", "\\").TrimStart('\\');

            string strFullPath = Path.Combine(strDestinationPath, strMfN);
            string strDirectoryPath = Path.GetDirectoryName(strFullPath);

            if (!Directory.Exists(strDirectoryPath))
            {
                Directory.CreateDirectory(strDirectoryPath);
            }

            if (System.IO.File.Exists(strFullPath))
            {
                try
                {
                    System.GC.Collect();
                    System.IO.File.Delete(strFullPath);
                }
                catch (Exception ex)
                {
                    return "Error deleting existing file: " + ex.Message;
                }
            }

            // const int bufferSize = 81920; // 80KB buffer size
            const int bufferSize = 1048576; // 80KB buffer size
            byte[] buffer = new byte[bufferSize];

            try
            {
                using (var fileStream = new FileStream(filePath, FileMode.Open, FileAccess.Read))
                using (
                    var destinationStream = new FileStream(
                        strFullPath,
                        FileMode.Create,
                        FileAccess.Write
                    )
                )
                {
                    int bytesRead;
                    while ((bytesRead = await fileStream.ReadAsync(buffer, 0, buffer.Length)) > 0)
                    {
                        await destinationStream.WriteAsync(buffer, 0, bytesRead);
                    }
                }

                return string.Empty;
            }
            catch (Exception ex)
            {
                return ex.Message;
            }
        }

        public async Task<string> UploadFileWithStreamToNetworkShare(string fileName, Stream stream)
        {
            if (stream == null)
            {
                throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
            }

            if (string.IsNullOrWhiteSpace(fileName))
            {
                throw new ArgumentNullException(
                    nameof(fileName),
                    "File name cannot be null or empty."
                );
            }

            // Network share path
            string strDestinationPath = _appSettings
                .FTPConfiguration.DestinationPathFile.ToString()
                .Trim();

            // Replace forward slashes with backslashes for network path
            string strMfN = fileName.Replace("/", "\\").TrimStart('\\');

            string strFullPath = Path.Combine(strDestinationPath, strMfN);
            string strDirectoryPath = Path.GetDirectoryName(strFullPath);

            // if (strDestinationPath.StartsWith(@"\\"))
            if (true)
            {
                try
                {
                    var networkPath = strDestinationPath;
                    var networkCredential = new NetworkCredential(
                        "krishna",
                        "Krishna@123",
                        "ICREATECH"
                    );

                    using (new NetworkConnection(networkPath, networkCredential))
                    {
                        if (!Directory.Exists(strDirectoryPath))
                        {
                            Directory.CreateDirectory(strDirectoryPath);
                        }
                    }
                }
                catch (UnauthorizedAccessException uaEx)
                {
                    return "Access denied. Check permissions on the network share.";
                }
                catch (Exception ex)
                {
                    return "Error creating directory: " + ex.Message;
                }
            }
            else
            {
                if (!Directory.Exists(strDirectoryPath))
                {
                    Directory.CreateDirectory(strDirectoryPath);
                }
            }

            if (System.IO.File.Exists(strFullPath))
            {
                return "File already exists.";
            }

            string filePath = Path.Combine(strDirectoryPath, Path.GetFileName(strFullPath));

            try
            {
                using (var fileStream = new FileStream(filePath, FileMode.Create, FileAccess.Write))
                {
                    await stream.CopyToAsync(fileStream);
                }

                return string.Empty; // Success
            }
            catch (Exception ex)
            {
                return "Error while uploading the file: " + ex.Message;
            }
        }

        public static void CreateNetworkDirectory(
            string networkPath,
            string username,
            string password
        )
        {
            try
            {
                // Prepare the network credentials
                NetworkCredential credentials = new NetworkCredential(
                    username,
                    password,
                    "WORKGROUP"
                ); // Use the appropriate domain

                CredentialCache credentialCache = new CredentialCache();
                credentialCache.Add(new Uri(networkPath), "Basic", credentials);

                string testFilePath = Path.Combine(networkPath, "temp.txt");
                if (!System.IO.File.Exists(networkPath))
                {
                    System.IO.File.Create(testFilePath).Dispose();
                }

                if (!Directory.Exists(networkPath))
                {
                    Directory.CreateDirectory(networkPath);
                }
                else { }
            }
            catch (UnauthorizedAccessException ex)
            {
                // Console.WriteLine("Access denied. Please check your network permissions.");
                // Console.WriteLine($"Error: {ex.Message}");
            }
            catch (Exception ex)
            {
                // Console.WriteLine("An error occurred while creating the directory.");
                // Console.WriteLine($"Error: {ex.Message}");
            }
        }

        static string ConvertFtpUrlToLocalPath(string ftpUrl, string localRootPath)
        {
            Uri uri = new Uri(ftpUrl);
            string ftpPath = uri.AbsolutePath;
            if (!Directory.Exists(localRootPath))
            {
                Directory.CreateDirectory(localRootPath);
            }

            string localFilePath = Path.Combine(
                localRootPath,
                ftpPath.TrimStart('/').Replace('/', Path.DirectorySeparatorChar)
            );

            return localFilePath;
        }

        public async Task<string> UploadFileWithStreamAsync(string fileName, Stream stream)
        {
            if (stream == null)
            {
                throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
            }

            if (string.IsNullOrWhiteSpace(fileName))
            {
                throw new ArgumentNullException(
                    nameof(fileName),
                    "File name cannot be null or empty."
                );
            }

            string ftpUrl = _appSettings.FTPConfiguration.FtpURL.ToString();
            string ftpUserName = _appSettings.FTPConfiguration.Username.ToString();
            string ftpPassword = _appSettings.FTPConfiguration.Password.ToString();

            if (!ftpUrl.StartsWith("ftp://", StringComparison.OrdinalIgnoreCase))
            {
                throw new ArgumentException("FTP URL must start with ftp://", nameof(ftpUrl));
            }

            if (!ftpUrl.EndsWith("/"))
            {
                ftpUrl += "/";
            }

            string uploadUrl = ftpUrl + fileName;

            try
            {
                Uri uri = new Uri(uploadUrl);
                string strFolderPath = uri.AbsoluteUri.Substring(
                    0,
                    uri.AbsoluteUri.LastIndexOf('/')
                );
                if (CheckFolderExists(strFolderPath, ftpUserName, ftpPassword) == false)
                    CreateFolder(strFolderPath, ftpUserName, ftpPassword);

                // Check if the file already exists, and if so, delete it
                if (await FileExistsAsync(uploadUrl, ftpUserName, ftpPassword))
                {
                    await DeleteFileAsync(uploadUrl, ftpUserName, ftpPassword);
                }

                // Create the FTP request to upload the file
                FtpWebRequest ftp = (FtpWebRequest)WebRequest.Create(uploadUrl);
                ftp.Credentials = new NetworkCredential(ftpUserName, ftpPassword);
                ftp.KeepAlive = true;
                ftp.UseBinary = true;
                ftp.UsePassive = true;
                ftp.Method = WebRequestMethods.Ftp.UploadFile;
                ftp.Timeout = 2400000; // Increased timeout for large files (40 minutes)
                ftp.ReadWriteTimeout = 2400000; // Increased read/write timeout for large files

                // Upload the file in chunks
                using (Stream ftpStream = await ftp.GetRequestStreamAsync())
                {
                    byte[] buffer = new byte[1048576]; // 1 MB buffer
                    int bytesRead;
                    while ((bytesRead = await stream.ReadAsync(buffer, 0, buffer.Length)) > 0)
                    {
                        await ftpStream.WriteAsync(buffer, 0, bytesRead);
                    }
                }

                using (FtpWebResponse response = (FtpWebResponse)await ftp.GetResponseAsync())
                {
                    return ""; // Return empty string for successful upload
                }
            }
            catch (WebException ex)
            {
                if (ex.Response is FtpWebResponse response)
                {
                    response.Close();
                }
                return "Exception: " + ex.Message;
            }
            catch (Exception ex)
            {
                return "Exception: " + ex.Message;
            }
        }

        public static byte[] ToImageBytes(string image)
        {
            if (string.IsNullOrEmpty(image))
                return null;

            try
            {
                // Remove the data:image part (if it exists) using a regex
                string base64String = Regex.Replace(
                    image,
                    @"^data:image\/(png|jpg|jpeg|gif|bmp);base64,",
                    string.Empty,
                    RegexOptions.IgnoreCase
                );

                // Decode the base64 string to bytes
                return Convert.FromBase64String(base64String);
            }
            catch (FormatException ex)
            {
                // Catch any base64 errors
                Console.WriteLine("Invalid base64 string: " + ex.Message);
                return null;
            }
        }

        [HttpPost("DeleteFTPFile")]
        public async Task<string> DeleteFTPFile(string fileNameWithDestinationPath)
        {
            bool isFTPMODE = _appSettings.FTPConfiguration.FTPMODE;
            string result = string.Empty;

            if (isFTPMODE == true)
            {
                result = await DeleteFileFTPAsync(fileNameWithDestinationPath);
            }
            else
            {
                result = await DeleteFileLocallyAsync(fileNameWithDestinationPath);
            }
            return result;
        }

        private async Task<string> DeleteFileFTPAsync(string sourceFilePath)
        {
            try
            {
                string FTPURL = _appSettings.FTPConfiguration.FtpURL.ToString();
                string FTPUserName = _appSettings.FTPConfiguration.Username.ToString();
                string FTPPassword = _appSettings.FTPConfiguration.Password.ToString();
                string strSourceFullPath = "";
                string strBasePath = _appSettings
                 .FTPConfiguration.DestinationPathFtp.ToString()
                 .Trim();
                sourceFilePath = sourceFilePath.Replace("/", "\\").TrimStart('\\');
                strSourceFullPath = Path.Combine(strBasePath, sourceFilePath);

                FtpWebRequest ftp = (FtpWebRequest)
                    WebRequest.Create(FTPURL + strSourceFullPath);
                ftp.Credentials = new NetworkCredential(FTPUserName, FTPPassword);
                ftp.KeepAlive = true;
                ftp.UseBinary = true;
                ftp.UsePassive = true;
                ftp.Method = WebRequestMethods.Ftp.DeleteFile;
                FtpWebResponse response = (FtpWebResponse)await ftp.GetResponseAsync();
                var statuscode = (int)response.StatusCode;
                response.Close();
                return "";
            }
            catch (WebException ex)
            {
                return "Error deleting file: " + ex.Message.ToString();
            }
        }

        private async Task<string> DeleteFileLocallyAsync(string sourceFilePath)
        {
            string strSourceFullPath = "";
            try
            {
                string strBasePath = _appSettings
                    .FTPConfiguration.DestinationPathFile.ToString()
                    .Trim();

                sourceFilePath = sourceFilePath.Replace("/", "\\").TrimStart('\\');
                strSourceFullPath = Path.Combine(strBasePath, sourceFilePath);

                if (!System.IO.File.Exists(strSourceFullPath))
                {
                    return "Source file does not exist.";
                }
                System.IO.File.Delete(strSourceFullPath);
                return "";
            }
            catch (Exception ex)
            {
                return "Error deleting file: " + ex.Message;
            }
        }

        public bool CheckIfFileExistsOnServer(string fileName)
        {
            string FTPURL = _appSettings.FTPConfiguration.FtpURL.ToString();
            string FTPUserName = _appSettings.FTPConfiguration.Username.ToString();
            string FTPPassword = _appSettings.FTPConfiguration.Password.ToString();

            var request = (FtpWebRequest)WebRequest.Create(FTPURL + fileName);
            request.Credentials = new NetworkCredential(FTPUserName, FTPPassword);
            request.Method = WebRequestMethods.Ftp.GetFileSize;
            request.KeepAlive = true;
            request.UseBinary = true;
            request.UsePassive = true;
            try
            {
                var response = (FtpWebResponse)request.GetResponse();
                response.Close();
                return true;
            }
            catch (WebException ex)
            {
                FtpWebResponse response = (FtpWebResponse)ex.Response;
                if (response.StatusCode == FtpStatusCode.ActionNotTakenFileUnavailable)
                {
                    response.Close();
                    return false;
                }
                response.Close();
            }
            return false;
        }

        public bool CheckFolderExists(string folderName, string username, string password)
        {
            try
            {
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(folderName);
                request.Credentials = new NetworkCredential(username, password);
                request.Method = WebRequestMethods.Ftp.ListDirectory;
                using (FtpWebResponse response = (FtpWebResponse)request.GetResponse())
                {
                    return true;
                }
            }
            catch (WebException ex)
            {
                FtpWebResponse response = (FtpWebResponse)ex.Response;
                if (response.StatusCode == FtpStatusCode.ActionNotTakenFileUnavailable)
                {
                    return false;
                }
                else
                {
                    return false;
                }
            }
        }

        public bool CreateFolder(string folderName, string username, string password)
        {
            try
            {
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(folderName);
                request.Credentials = new NetworkCredential(username, password);
                request.Method = WebRequestMethods.Ftp.MakeDirectory;
                using (FtpWebResponse response = (FtpWebResponse)request.GetResponse())
                {
                    return true;
                }
            }
            catch (WebException ex)
            {
                return false;
            }
        }


        [HttpPost("MoveFileAsync")]
        public async Task<string> MoveFileAsync(string sourceFilePath, string destinationFilePath)
        {
            if (
                string.IsNullOrWhiteSpace(sourceFilePath)
                || string.IsNullOrWhiteSpace(destinationFilePath)
            )
            {
                return "Source and destination file paths cannot be null or empty.";
            }

            bool isFTPMODE = _appSettings.FTPConfiguration.FTPMODE; // Check the FTP mode setting
            string result = string.Empty;

            try
            {
                if (isFTPMODE) // FTP Mode
                {
                    // If FTP Mode is enabled, you can implement FTP file transfer logic
                    //result = await MoveFileToFtpAsync(sourceFilePath, destinationFilePath);
                    result = await MoveFileLocallyAsync(sourceFilePath, destinationFilePath);
                }
                else // Local File Mode
                {
                    // In Local File Mode, perform the file move locally
                    result = await MoveFileLocallyAsync(sourceFilePath, destinationFilePath);
                }

                return result;
            }
            catch (Exception ex)
            {
                return "Error moving file: " + ex.Message;
            }
        }

        private async Task<string> MoveFileLocallyAsync(
            string sourceFilePath,
            string destinationFilePath
        )
        {
            string strSourceFullPath = "";
            string strDestinationFullPath = "";
            try
            {
                string strBasePath = _appSettings
                    .FTPConfiguration.DestinationPathFile.ToString()
                    .Trim();

                sourceFilePath = sourceFilePath.Replace("/", "\\").TrimStart('\\');
                destinationFilePath = destinationFilePath.Replace("/", "\\").TrimStart('\\');

                strSourceFullPath = Path.Combine(strBasePath, sourceFilePath);
                strDestinationFullPath = Path.Combine(strBasePath, destinationFilePath);

                // string strDestinationDirectory = Path.GetDirectoryName(strDestinationFullPath);

                // Ensure the source file exists
                if (!System.IO.File.Exists(strSourceFullPath))
                {
                    return "Source file does not exist.";
                }
                if (!Directory.Exists(strDestinationFullPath))
                {
                    Directory.CreateDirectory(strDestinationFullPath);
                }

                strDestinationFullPath = Path.Combine(
                    strDestinationFullPath,
                    Path.GetFileName(strSourceFullPath)
                );
                // Move the file from source to destination
                System.IO.File.Move(strSourceFullPath, strDestinationFullPath);

                return ""; // Return empty string if move was successful
            }
            catch (Exception ex)
            {
                return "Error moving file : " + ex.Message;
            }
        }

        //----------------------------------------history function ----------------------------------------------------------

        [HttpGet("CheckPatAdmExist")]
        public IActionResult GetHist_CheckPatAdmExist(int Parm_PatientId, string Parm_OldUMRNo, string Parm_NewUMRNo, int Parm_AdmId, string Parm_OldIPNo, string Parm_NewIPNo, Boolean Parm_IsEdit)
        {
            log.Debug("CheckPatAdmExist ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetHist_CheckPatAdmExist(Parm_PatientId, Parm_OldUMRNo, Parm_NewUMRNo, Parm_AdmId, Parm_OldIPNo, Parm_NewIPNo, Parm_IsEdit);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for CheckPatAdmExist - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetHistPatientData")]
        public IActionResult GetHistPatientData(int Parm_PatientId)
        {
            log.Debug("GetHistPatientData ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetHist_PatientData(Parm_PatientId);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for GetHistPatientData - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetHistAdmissionData")]
        public IActionResult GetAdmissionHistoryData(int Parm_HistAdmId)
        {
            log.Debug("GetHistAdmissionData ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetHist_AdmissIonData(Parm_HistAdmId);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for GetHistAdmissionData - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("LoadLookupValues")]
        public IActionResult LoadLookupValues(string Parm_LookupName, string Parm_WhereCond, Boolean Parm_ShowBlankRow)
        {
            log.Debug("LoadLookupValues ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.LoadLookupValues(Parm_LookupName, Parm_WhereCond, Parm_ShowBlankRow);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for LoadLookupValues - Error:" + ex.Message);
                return NotFound("No results");
            }
        }


        [HttpPost("SaveHistAdmissionDischargeData")]
        public IActionResult SaveHistAdmissionDischargeData([FromBody] string Parm_AdmData)
        {
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                int savedCount = adapter.SaveHistoryOfAdmissionDischargeData(Parm_AdmData);

                log.Info($"SaveHistAdmissionDischargeData => Successfully saved {savedCount} records.");
                return Ok(savedCount);
            }
            catch (Exception ex)
            {
                log.Error("SaveHistAdmissionDischargeData -> Failed to save data - " + ex.Message);
                return StatusCode(500, "Internal server error");
            }

        }

        [HttpPost("ExecuteNonQuery")]
        public string ExecuteNonQuery([FromBody] string jsonSql)
        {
            if (string.IsNullOrWhiteSpace(jsonSql))
            {
                log.Error("Request string is null or empty.");
                return "Request string is null or empty.";
            }

            return new FTPDataAdapter(_appSettings).ExecuteNonQuery(jsonSql);
        }


        [HttpPost("SaveHistoryPatient")]
        public int SaveHistoryPatient([FromBody] string Parm_PatientData)//string Parm_PatientData
        {
            int savedCount = 0;
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                savedCount = adapter.SaveHistoryOfPatient(Parm_PatientData);
            }
            catch (Exception ex)
            {
                log.Error("SaveHistoryPatient -> Failed to save documents - Error: " + ex.Message);
            }
            return savedCount;
        }

        [HttpGet("GetDocumentCountList")]
        public IActionResult GetDocumentCountList(string Parm_Year,int Parm_DType)
        {
            log.Debug("GetDocumentCountList ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetDocumentCountList(Parm_Year,Parm_DType);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for GetDocumentCountList - Error:" + ex.Message);
                return NotFound("No results");
            }
        }


        //-------------------------------------------------------------------Patient docs Merge Api -----------------------
        [HttpGet("GetPatientMergeDocuments")]
        public async Task<bool> GetPatientMergeDocuments(int PatientID)
        {
            try
            {
                string rawPrimaryPath = _appSettings.FolderOptions.PrimaryFolderPath;
                string rawSecondaryPath = _appSettings.FolderOptions.SecondaryFolderPath;

                string primaryFolderPath = NormalizePathForCurrentOS(rawPrimaryPath);
                string secondaryFolderPath = NormalizePathForCurrentOS(rawSecondaryPath);

                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<PatientDocumentsPathsData>? documentPaths = adapter.GetPatientDocumentPaths(
                    PatientID,
                    primaryFolderPath,
                    secondaryFolderPath
                );

                if (documentPaths == null || documentPaths.Count == 0)
                    return false;

                List<byte[]> pdfByteArrays = new List<byte[]>();

                foreach (var doc in documentPaths)
                {
                    if (doc == null || string.IsNullOrWhiteSpace(doc.DocumentPath))
                        continue;


                    string FileFullPath = Path.GetFullPath(doc.DocumentPath);
                    await ProcessPatientDocFile(FileFullPath, pdfByteArrays);
                }

                if (pdfByteArrays.Count == 0)
                    return false;

                byte[] mergedPdfBytes = ConcatenatePdfs_New(pdfByteArrays);

                var SavedPathFile = documentPaths
                    ?.FirstOrDefault(doc => doc.PatientId == PatientID)
                    ?.DocumentPath;

                if (!string.IsNullOrEmpty(SavedPathFile))
                {
                    string strFileFullPath = Path.GetFullPath(SavedPathFile)
                    .Replace(primaryFolderPath, "")
                    .Replace(secondaryFolderPath, "");

                    string[] parts = strFileFullPath.Split('\\');
                    string resultpath = ""; string outputFileName = "";

                    if (parts.Length >= 3)
                    {
                        string patientId = parts[1];
                        string guid = parts[2];
                        outputFileName = Path.Combine($"{patientId}\\{guid}\\{"ALL Info"}", $"{PatientID}_AllInfoPatDocuments.pdf");
                    }
                    string outputFilePath = Path.Combine(primaryFolderPath, outputFileName);
                    var directoryPath = Path.GetDirectoryName(outputFilePath);
                    if (!Directory.Exists(directoryPath))
                    {
                        Directory.CreateDirectory(directoryPath);
                    }
                    await System.IO.File.WriteAllBytesAsync(outputFilePath, mergedPdfBytes);
                }
                return true;
            }
            catch (Exception ex)
            {
                // Optional: use proper logger
                Console.WriteLine(
                    $"GetPatientMergeDocuments failed for PatientID={PatientID}: {ex.Message}"
                );
                return false;
            }
        }

        private async Task ProcessPatientDocFile(string filePath, List<byte[]> pdfByteList)
        {
            if (!System.IO.File.Exists(filePath))
                return;

            string ext = Path.GetExtension(filePath).ToLowerInvariant();

            if (ext == ".doc" || ext == ".docx")
                return;

            try
            {
                byte[] pdfBytes;

                if (ext == ".pdf")
                {
                    pdfBytes = await System.IO.File.ReadAllBytesAsync(filePath);
                }
                else
                {
                    pdfBytes = ConvertImageToPdfBytes(filePath);
                }

                if (pdfBytes != null && pdfBytes.Length > 0)
                {
                    pdfByteList.Add(pdfBytes);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"Error processing file: {filePath}, {ex.Message}");
            }
        }
        public string NormalizePathForCurrentOS(string path)
        {
            if (string.IsNullOrEmpty(path))
                return path;

            if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
            {
                // Convert forward slashes to backslashes
                path = path.Replace('/', '\\');

                // If path is like "D:", add trailing backslash
                if (path.Length == 2 && path[1] == ':')
                    path += '\\';

                return path;
            }
            else if (
                RuntimeInformation.IsOSPlatform(OSPlatform.Linux)
                || RuntimeInformation.IsOSPlatform(OSPlatform.OSX)
            )
            {
                // Convert backslashes to forward slashes
                return path.Replace('\\', '/');
            }
            else
            {
                throw new PlatformNotSupportedException("Unsupported OS platform.");
            }
        }

        private async Task ProcessFolderFiles(string folderPath, List<byte[]> pdfByteList)
        {
            if (!Directory.Exists(folderPath))
                return;

            string[] files = Directory.GetFiles(folderPath, "*.*", SearchOption.AllDirectories);
            foreach (var file in files)
            {
                string ext = Path.GetExtension(file).ToLowerInvariant();
                if (ext == ".doc" || ext == ".docx")
                    continue;

                byte[] pdfBytes;
                if (ext == ".pdf")
                {
                    pdfBytes = await System.IO.File.ReadAllBytesAsync(file);
                }
                else
                {
                    pdfBytes = ConvertImageToPdfBytes(file);
                }
                pdfByteList.Add(pdfBytes);
            }
        }

        public byte[] ConcatenatePdfs_New(List<byte[]> documents)
        {
            PdfReader.unethicalreading = true;

            using (var ms = new MemoryStream())
            {
                iTextSharp.text.Document document = new iTextSharp.text.Document();
                PdfCopy copy = new PdfCopy(document, ms);
                document.Open();

                foreach (var pdfBytes in documents)
                {
                    using (var inputPdfStream = new MemoryStream(pdfBytes))
                    {
                        PdfReader reader = new PdfReader(inputPdfStream);
                        reader.ConsolidateNamedDestinations();

                        for (int i = 1; i <= reader.NumberOfPages; i++)
                        {
                            copy.AddPage(copy.GetImportedPage(reader, i));
                        }

                        copy.FreeReader(reader);
                        reader.Close();
                    }
                }

                document.Close();
                return ms.ToArray();
            }
        }

        private byte[] ConvertImageToPdfBytes(string imagePath)
        {
            using (MemoryStream ms = new MemoryStream())
            {
                using (
                    iTextSharp.text.Document doc = new iTextSharp.text.Document(
                        iTextSharp.text.PageSize.A4
                    )
                )
                {
                    PdfWriter.GetInstance(doc, ms);
                    doc.Open();

                    iTextSharp.text.Image img = iTextSharp.text.Image.GetInstance(imagePath);
                    img.ScaleToFit(doc.PageSize.Width - 40, doc.PageSize.Height - 40);
                    img.Alignment = iTextSharp.text.Element.ALIGN_CENTER;

                    doc.Add(img);
                    doc.Close();
                }
                return ms.ToArray();
            }
        }

        // private async Task<string> MoveFileToFtpAsync(string sourceFilePath, string destinationFilePath)
        // {
        //     try
        //     {
        //         // FTP file move logic will go here
        //         // Example: Upload the file to FTP and delete the source file after upload

        //         var ftpClient = new FtpClient( _appSettings.FTPConfiguration.FtpURL,_appSettings.FTPConfiguration.Username, _appSettings.FTPConfiguration.Password); //_appSettings.FTPConfiguration.ServerUrl,

        //         // Upload the file to FTP (assuming you have an FTP client setup)
        //         bool uploadResult = await ftpClient.UploadFileAsync(sourceFilePath, destinationFilePath);
        //         if (!uploadResult)
        //         {
        //             return "Error uploading file to FTP.";
        //         }

        //         // Once uploaded, delete the source file locally if the upload is successful
        //         if (System.IO.File.Exists(sourceFilePath))
        //         {
        //             System.IO.File.Delete(sourceFilePath);
        //         }

        //         return string.Empty; // Return empty string if move was successful
        //     }
        //     catch (Exception ex)
        //     {
        //         return "Error moving file to FTP: " + ex.Message;
        //     }
        // }


        private byte[] DecryptFile(byte[] encryptedData, string encryptionKey)
        {
            byte[] keyBytes = Encoding.UTF8.GetBytes(encryptionKey);
            byte[] decryptedBytes;

            using (MemoryStream encryptedStream = new MemoryStream(encryptedData))
            using (MemoryStream decryptedStream = new MemoryStream())
            using (Aes aes = Aes.Create())
            {
                aes.Key = keyBytes;
                aes.IV = keyBytes.Take(16).ToArray();

                using (ICryptoTransform decryptor = aes.CreateDecryptor())
                using (CryptoStream cryptoStream = new CryptoStream(encryptedStream, decryptor, CryptoStreamMode.Read))
                {
                    cryptoStream.CopyTo(decryptedStream);
                }

                decryptedBytes = decryptedStream.ToArray();
            }

            return decryptedBytes;
        }

        [HttpPost("GetMRDCompressedIcons")]
        public async Task<IActionResult> GetMRDCompressedIcons(
             [FromBody] DocumentResponseModel model
         )
        {
            if (model == null || string.IsNullOrWhiteSpace(model.FolderPath))
                return BadRequest("Folder path is required.");

            if (model.FilePaths == null || model.FilePaths.Count == 0)
                return BadRequest("No file paths provided.");

            string baseDir = _appSettings.MappedDriveSettings.BaseDirectory;
            string encryptionKey = "12345678909876543210123456789098";
            var results = new List<object>();

            foreach (var fileName in model.FilePaths)
            {
                if (string.IsNullOrWhiteSpace(fileName))
                {
                    results.Add(new { Path = fileName, Error = "Empty file name" });
                    continue;
                }

                string mainFolder = model.FolderPath.Replace(
                    "/",
                    Path.DirectorySeparatorChar.ToString()
                );
                string fullPath = Path.Combine(baseDir, mainFolder, fileName);

                try
                {
                    if (!System.IO.File.Exists(fullPath))
                    {
                        results.Add(
                            new
                            {
                                Path = Path.Combine(mainFolder, fileName),
                                Error = "File not found"
                            }
                        );
                        continue;
                    }

                    byte[] encryptedData = await System.IO.File.ReadAllBytesAsync(fullPath);
                    byte[] decryptedBytes = DecryptFile(encryptedData, encryptionKey);

                    using var msDecrypted = new MemoryStream(decryptedBytes);
                    using var originalImage = Image.FromStream(msDecrypted);

                    int height = int.Parse(_appSettings.ResolutionSettings.Height);
                    int width = int.Parse(_appSettings.ResolutionSettings.Width);

                    using var resizedImage = ResizeImage(originalImage, width, height);

                    using var msResized = new MemoryStream();
                    resizedImage.Save(msResized, ImageFormat.Jpeg);
                    string base64 = Convert.ToBase64String(msResized.ToArray());

                    results.Add(new { Path = Path.Combine(mainFolder, fileName), Base64 = base64 });
                }
                catch (Exception ex)
                {
                    results.Add(
                        new { Path = Path.Combine(mainFolder, fileName), Error = ex.Message }
                    );
                }
            }

            return Ok(results);
        }

        private Image ResizeImage(Image img, int width, int height)
        {
            var bmp = new Bitmap(width, height);
            using (Graphics g = Graphics.FromImage(bmp))
            {
                g.CompositingQuality = CompositingQuality.HighQuality;
                g.InterpolationMode = InterpolationMode.HighQualityBicubic;
                g.SmoothingMode = SmoothingMode.HighQuality;
                g.DrawImage(img, 0, 0, width, height);
            }
            img.Dispose();
            return bmp;
        }




        public void WriteLog(string SndException)
        {
            string strfname = Convert.ToString(DateTime.Today.ToString("yyyy-MM-dd"));
            string strDirectory =
                System
                    .IO.Path.GetDirectoryName(
                        System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase
                    )
                    .Replace("file:\\", "") + "\\LOGDetails";
            string strFile =
                System
                    .IO.Path.GetDirectoryName(
                        System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase
                    )
                    .Replace("file:\\", "")
                + "\\LOGDetails\\"
                + strfname
                + ".txt";
            if (!System.IO.Directory.Exists(strDirectory))
            {
                System.IO.Directory.CreateDirectory(strDirectory);
            }

            StreamWriter objStreamWriter = default(StreamWriter);
            if (!System.IO.File.Exists(strFile))
            {
                FileStream fs = new FileStream(strFile, FileMode.Create, FileAccess.Write);
                objStreamWriter = new StreamWriter(fs);
                objStreamWriter.BaseStream.Seek(0, SeekOrigin.End);
            }
            else
            {
                objStreamWriter = System.IO.File.AppendText(strFile);
            }

            objStreamWriter.WriteLine(SndException);
            objStreamWriter.Close();
        }
    }
}
