namespace FTP_Services.Core.Models
{
    public class PatientDocumentDetailsModel
    {
        public string DocumentType { get; set; }
        public string Description { get; set; }
        public string DocumentName { get; set; }
        public int UploadedBy { get; set; }
        public int PatientId { get; set; }
        public string ContentType { get; set; }
        public string Size { get; set; }
        public string DocumentUrl { get; set; }
        public string ThumbnailUrl { get; set; }
        public int SplID { get; set; }
         public int PatDocId { get; set; }
         public string UploadedDate  { get; set; }

        public PatientDocumentDetailsModel()
        {
            DocumentType = "";
            Description = "";
            DocumentName = "";
            UploadedBy = -1;
            PatientId = -1;
            ContentType = "";
            Size = "";
            DocumentUrl = "";
            ThumbnailUrl = "";
            SplID = -1;
             PatDocId = 0;
             UploadedDate = "";
        }
    }

    // public class Login
    // {
    //     public string ID { get; set; }
    //     public string Name { get; set; }
    //     public string Code { get; set; }

    //     public Login()
    //     {
    //         ID = "";
    //         Name = "";
    //         Code = "";
    //     }
    // }

    public class FileResponseModel
    {
        public string Base64String { get; set; }

        public FileResponseModel()
        {
            Base64String = "";
        }
    }

    public class LoginResponseModel
    {
        public string UserName { get; set; }

        public LoginResponseModel()
        {
            UserName = "";
        }
    }

    public class Login
    {
        public int UserID { get; set; }
        public string UserName { get; set; }
        public string FullName { get; set; }
        public bool Active { get; set; }
        public bool IsLocked { get; set; }
        public string SaltKey { get; set; }
        public string PasswordHash { get; set; }
        public string GCClientID { get; set; }

        public Login()
        {
            UserID = -1;
            UserName = "";
            FullName = "";
            Active = false;
            IsLocked = false;
            SaltKey = "";
            PasswordHash = "";
            GCClientID = "";
        }
    }

    public class SearchPatients
    {
        public int PatientID { get; set; }
        public string UMRNo { get; set; }
        public string FullName { get; set; }
        public string DOB { get; set; }
        public int Age { get; set; }
        public string Mobile { get; set; }
        public string RegNo { get; set; }
        public string Guid { get; set; }
        public int DocCount { get; set; }

        public SearchPatients()
        {
            PatientID = -1;
            UMRNo = "";
            FullName = "";
            DOB = "";
            Age = -1;
            Mobile = "";
            RegNo = "";
            Guid = "";
            DocCount = -1;
        }
    }

    public class DocumentCategories
    {
        public int ID { get; set; }
        public string Name { get; set; }

        public DocumentCategories()
        {
            ID = -1;
            Name = "";
        }
    }

    public class Specialities
    {
        public int ID { get; set; }
        public string Name { get; set; }

        public Specialities()
        {
            ID = -1;
            Name = "";
        }
    }
     public class ConfigValues
    {
        public int ID { get; set; }
        public string Environment { get; set; }
        public string RemotePath { get; set; }

        public string CompanyName { get; set; }
        public string FTPServiceURL { get; set; }
        public int DPI { get; set; }
        public int PDFSizeLimit { get; set; }
        public string DefaultDocType { get; set; }
        public bool IsActive { get; set; }

        public ConfigValues()
        {
            ID = -1;
            Environment = "";
            RemotePath = "";
            CompanyName = "";
            FTPServiceURL = "";
            DPI =100;
            PDFSizeLimit =20;
            DefaultDocType ="";
            IsActive = true;
        }
    }

    public class PatientDocuments
    {
        public int PatientId { get; set; }
        public string Guid { get; set; }
        public string UMRNo { get; set; }
        public int PatientDocumentId { get; set; }
        public string DocumentType { get; set; }
        public string DocumentName { get; set; }
        public string Description { get; set; }
        public string ContentType { get; set; }
        public string Size { get; set; }
        public string IsRead { get; set; }
        public string UploadedDate { get; set; }
        public int UploadedBy { get; set; }
        public string UploadedByName { get; set; }
        public string UploadedByRole { get; set; }
        public string FullName { get; set; }
        public string DocumentUrl { get; set; }
        public int SplID { get; set; }
        public string ThumbnailUrl { get; set; }
        

        public PatientDocuments()
        {
            PatientId = -1;
            Guid = "";
            UMRNo = "";
            PatientDocumentId = -1;
            DocumentType = "";
            DocumentName = "";
            Description = "";
            ContentType = "";
            Size = "";
            IsRead = "";
            UploadedDate = "";
            UploadedBy = -1;
            UploadedByName = "";
            UploadedByRole = "";
            FullName = "";
            DocumentUrl = "";
            SplID = -1;
            ThumbnailUrl ="";
        }
    }

    public class ValidUserCount
    {
        public int RecordCount { get; set; }

        public ValidUserCount()
        {
            RecordCount = -1;
        }
    }
}
