namespace FTP_Services.Core.Models
{
    public class PatientDocumentDetailsModel
    {
        public int DocumentType { get; set; }
        public string Description { get; set; }
        public string DocumentName { get; set; }
        public int UploadedBy { get; set; }
        public int PatientId { get; set; }
        public string ContentType { get; set; }
        public int Size { get; set; }
        public string DocumentUrl { get; set; }
        public string ThumbnailUrl { get; set; }
        public int SplID { get; set; }
        public int PatDocId { get; set; }
        public string UploadedDate { get; set; }
        public int AdmissionID { get; set; }
        public int SortNo { get; set; }
        public int RecType { get; set; }

        public PatientDocumentDetailsModel()
        {
            DocumentType = 0;
            Description = "";
            DocumentName = "";
            UploadedBy = -1;
            PatientId = -1;
            ContentType = "";
            Size = 0;
            DocumentUrl = "";
            ThumbnailUrl = "";
            SplID = -1;
            PatDocId = 0;
            UploadedDate = "";
            AdmissionID = 0;
            SortNo = 1;
            RecType = 1;
        }
    }


    public class FileResponseModel
    {
        public string Base64String { get; set; }

        public FileResponseModel()
        {
            Base64String = "";
        }
    }

    public class LoginResponseModel
    {
        public string UserName { get; set; }

        public LoginResponseModel()
        {
            UserName = "";
        }
    }

    public class Login
    {
        public int UserID { get; set; }
        public string UserName { get; set; }
        public string FullName { get; set; }
        public bool Active { get; set; }
        public bool IsLocked { get; set; }
        public string SaltKey { get; set; }
        public string PasswordHash { get; set; }
        public string GCClientID { get; set; }

        public Login()
        {
            UserID = -1;
            UserName = "";
            FullName = "";
            Active = false;
            IsLocked = false;
            SaltKey = "";
            PasswordHash = "";
            GCClientID = "";
        }
    }

    public class SearchPatients
    {
        public int PatientID { get; set; }
        public string UMRNo { get; set; }
        public string FullName { get; set; }
        public string DOB { get; set; }
        public int Age { get; set; }
        public string Mobile { get; set; }
        public string RegNo { get; set; }
        public string Guid { get; set; }
        public int DocCount { get; set; }

        public SearchPatients()
        {
            PatientID = -1;
            UMRNo = "";
            FullName = "";
            DOB = "";
            Age = -1;
            Mobile = "";
            RegNo = "";
            Guid = "";
            DocCount = -1;
        }
    }

    public class DocumentCategories
    {
        public int ID { get; set; }
        public string Name { get; set; }

        public DocumentCategories()
        {
            ID = -1;
            Name = "";
        }
    }

    public class Specialities
    {
        public int ID { get; set; }
        public string Name { get; set; }

        public Specialities()
        {
            ID = -1;
            Name = "";
        }
    }
    public class ConfigValues
    {
        public int ID { get; set; }
        public string Environment { get; set; }
        public string RemotePath { get; set; }

        public string CompanyName { get; set; }
        public string FTPServiceURL { get; set; }
        public int DPI { get; set; }
        public int PDFSizeLimit { get; set; }
        public string DefaultDocType { get; set; }
        public bool IsActive { get; set; }
        public int CompanyId { get; set; }
        public string DatabaseName { get; set; }
        public string RemoteHost { get; set; }
        public string RemoteUser { get; set; }
        public string RemotePassword { get; set; }
        public string RemotePort { get; set; }
        public string ToolVersion { get; set; }


        public ConfigValues()
        {
            ID = -1;
            Environment = "";
            RemotePath = "";
            CompanyName = "";
            FTPServiceURL = "";
            DPI = 100;
            PDFSizeLimit = 20;
            DefaultDocType = "";
            IsActive = true;
            CompanyId = 1;
            DatabaseName = "";
            RemoteHost = "";
            RemoteUser = "";
            RemotePassword = "";
            RemotePort = "";
            ToolVersion = "";
        }
    }

    public class PatientDocuments
    {
        public int PatientId { get; set; }
        public string Guid { get; set; }
        public string UMRNo { get; set; }
        public int PatientDocumentId { get; set; }
        public string DocumentType { get; set; }
        public string DocumentName { get; set; }
        public string Description { get; set; }
        public string ContentType { get; set; }
        public string Size { get; set; }
        public string IsRead { get; set; }
        public string UploadedDate { get; set; }
        public int UploadedBy { get; set; }
        public string UploadedByName { get; set; }
        public string UploadedByRole { get; set; }
        public string FullName { get; set; }
        public string DocumentUrl { get; set; }
        public int SplID { get; set; }
        public string ThumbnailUrl { get; set; }
        public bool IsExternal { get; set; }
        public int AdmissionId { get; set; }
        public string AdmissionNo { get; set; }

        public string AdmissionDate { get; set; }


        public PatientDocuments()
        {
            PatientId = -1;
            Guid = "";
            UMRNo = "";
            PatientDocumentId = -1;
            DocumentType = "";
            DocumentName = "";
            Description = "";
            ContentType = "";
            Size = "";
            IsRead = "";
            UploadedDate = "";
            UploadedBy = -1;
            UploadedByName = "";
            UploadedByRole = "";
            FullName = "";
            DocumentUrl = "";
            SplID = -1;
            ThumbnailUrl = "";
            IsExternal = false;
            AdmissionId = -1;
            AdmissionNo = "";
            AdmissionDate = "";
        }
    }
    public class Admissions
    {
        public int ID { get; set; }
        public string AdmissionNo { get; set; }

        public Admissions()
        {
            ID = -1;
            AdmissionNo = "";
        }
    }

    public class ValidUserCount
    {
        public int RecordCount { get; set; }

        public ValidUserCount()
        {
            RecordCount = -1;
        }
    }
    public class AdmissionDischargeHistData
    {
        public string Parm_AdmData { get; set; }
    }
    public class PatientHistData
    {
        public string Parm_PatientData { get; set; }
    }
    public class SQLRequest
    {
        public string sql { get; set; }
    }


    public class AdmissionDischargeModel
    {
        public int MRDId { get; set; }
        public int PatientId { get; set; }
        public int AdmissionId { get; set; }
        public int ProviderId { get; set; }
        public int LocationId { get; set; }
        public int DepartmentId { get; set; }
        public int AdmissionAge { get; set; }
        public DateTime? AdmissionDate { get; set; }
        public int AdmissionTypeId { get; set; }
        public DateTime? DischargeDate { get; set; }
        //public int DischargeTypeId { get; set; }
        public string DischargeType { get; set; }
        public string Cause { get; set; }
        public int UserId { get; set; }
        public bool IsWardChanged { get; set; }
        public bool IsICDChanged { get; set; }
        public bool IsProcChanged { get; set; }
        public List<WardModel> Wards { get; set; }
        public List<ICDModel> ICDCodes { get; set; }
        public List<ProcedureModel> Procedures { get; set; }
        public string Diagnosis { get; set; }
        public string MRD_OtherProcedures { get; set; }

        public int RecType { get; set; }
    }

    // Supporting Models
    public class WardModel
    {
        public int WardId { get; set; }
        public DateTime WardDate { get; set; }
    }

    public class ICDModel
    {
        public string ICDCode { get; set; }
        public string ICDDesc { get; set; }
    }

    public class ProcedureModel
    {
        public string ProcName { get; set; }

    }


    public class PatientImgDocSort
    {
        public int UserId { get; set; }
        public List<PatientImgDocModel> PatientImgDoc { get; set; }
    }
    public class PatientImgDocModel
    {
        public int PatDocId { get; set; }
        public int SortNo { get; set; }
    }
    public class PatientDocumentsPathsData
    {
        public int PatientId { get; set; }
        public int PatientDocumentId { get; set; }
        public bool ExternalFtp { get; set; }
        public string? DocumentName { get; set; }
        public string? DocumentPath { get; set; }
    }

    public class DocumentResponseModel
    {
        public string? FolderPath { get; set; }
        public List<string>? FilePaths { get; set; }
    }
}
