using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Configuration;
using PetaPoco;
using Microsoft.Extensions.Options;
using FTP_Services.Core.Models;

namespace FTP_Services.Services
{
    public class BaseDataAdapter : IDisposable
    {
        #region Variables
        protected PetaPoco.Database _repository;
        //protected IConfiguration _configuration;
        protected AppSettings _appSettings;
        protected readonly log4net.ILog log = log4net.LogManager.GetLogger("BaseDataAdapter");
        protected int _auth_user_id;
        protected int _user_id;
        #endregion
        public BaseDataAdapter(AppSettings appSettings)
        {
            log.Debug("BaseDataAdapter() called");
            //this._configuration=configuration;
            //string constr = _configuration.GetSection("MySettings").GetSection("ConnectionString").Value;
            this._appSettings=appSettings;
            string constr = _appSettings.ConnectionString;
            log.Debug("Connection String -" + constr);
            // this._repository = new PetaPoco.Database(new Npgsql.NpgsqlConnection(constr));
            _auth_user_id=0;
            _user_id=0;
            // this._repository = new PetaPoco.Database(constr,"Microsoft.Data.SqlClient");
            _repository = new PetaPoco.Database(constr, "npgsql");
        }

        public void Dispose()
        {
            if(this._repository.Connection!=null)
                this._repository.Connection.Close();
            this._repository.Dispose();
        }
    }
}