using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Net;
using System.Runtime.InteropServices;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Threading.Tasks;
using FTP_Services.Core.Models;
using FTP_Services.Services;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Options;

namespace FTP_Services.Services.Controllers
{
    public class FTPManagementAPIController : BaseAPIController
    {
        private readonly AppSettings _appSettings;
        private readonly Microsoft.AspNetCore.Hosting.IWebHostEnvironment _hostingEnvironment;

        // public FTPManagementAPIController(
        //     IOptions<AppSettings> appSettings,
        //     IConfiguration configuration,
        //     Microsoft.AspNetCore.Hosting.IWebHostEnvironment hostingEnvironment
        // )
        //     : base(appSettings.Value)
        public FTPManagementAPIController(IOptions<AppSettings> appSettings)
            : base(appSettings.Value)
        {
            log.Info("FTPManagementAPIController : Constractor");
            _appSettings = appSettings.Value;
            //  _hostingEnvironment = hostingEnvironment;
        }

        [HttpPost("GetLoginDetails")]
        public IActionResult GetLoginDetails([FromBody] LoginResponseModel model)
        {
            // _hostingEnvironment.log("GetLoginDetails  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<Login>? RequestsList = adapter.LoginData(model.UserName);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for login - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetSearchedHistoryPatients")]
        public IActionResult GetSearchedHistoryPatients(string SearchText, int ProviderId, int LocationId, int DateType, string StartDate, string EndDate)
        {
            log.Debug("GetSearchedPatients  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                // List<SearchPatients>? RequestsList = adapter.SearchedPatientsData(SearchText);
                List<object>? RequestsList = adapter.SearchedPatientsHistoryData(SearchText, ProviderId, LocationId, DateType, StartDate, EndDate);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for search patients - Error:" + ex.Message);
                return NotFound("No results");
            }
        }
        [HttpGet("GetSearchedPatients")]
        public IActionResult GetSearchedPatients(string SearchText, int ProviderId, int LocationId, int DateType, string StartDate, string EndDate, int DischType)
        {
            log.Debug("GetSearchedPatients  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                // List<SearchPatients>? RequestsList = adapter.SearchedPatientsData(SearchText);
                List<object>? RequestsList = adapter.SearchedPatientsData(SearchText, ProviderId, LocationId, DateType, StartDate, EndDate, DischType);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for search patients - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetAdmissionDataHistory")]
        public IActionResult GetAdmissionDataHistory(int PatientID, int LocationID, int ProviderID, int DateType, string StartDate, string EndDate)
        {
            log.Debug("GetAdmissionDataHistory  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetAdmissionDataHistory(PatientID, LocationID, ProviderID, DateType, StartDate, EndDate);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for GetAdmissionDataHistory - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetAdmissionData")]
        public IActionResult GetAdmissionData(int PatientID, int LocationID, int ProviderID, int DateType, string StartDate, string EndDate, int DischType)
        {
            log.Debug("GetAdmissionData  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetAdmissionData(PatientID, LocationID, ProviderID, DateType, StartDate, EndDate, DischType);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for Admissions - Error:" + ex.Message);
                return NotFound("No results");
            }
        }
        [HttpGet("LoadPhysicians")]
        public IActionResult GetLoadPhysicians(int LocationId,Boolean IsOldData)
        {
            log.Debug("LoadPhysicians  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GeLoadPhysicians(LocationId,IsOldData);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for GetLoadPhysicians - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetLocations")]
        public IActionResult GetLocations(Boolean IsLoadAll,Boolean IsOldData) //int LocationId, 
        {
            log.Debug("GetLocations  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.LoadLocations(IsLoadAll,IsOldData);//LocationId, 
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for GetLocations - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        private async Task<bool> FileExistsAsync(string fileUrl, string username, string password)
        {
            try
            {
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(fileUrl);
                request.Credentials = new NetworkCredential(username, password);
                request.Method = WebRequestMethods.Ftp.GetFileSize;
                request.Timeout = 2400000; // Increased timeout
                request.ReadWriteTimeout = 2400000; // Increased read/write timeout

                using (FtpWebResponse response = (FtpWebResponse)await request.GetResponseAsync())
                {
                    return response.StatusCode == FtpStatusCode.FileStatus;
                }
            }
            catch (WebException ex)
            {
                if (ex.Response is FtpWebResponse response)
                {
                    if (response.StatusCode == FtpStatusCode.ActionNotTakenFileUnavailable)
                    {
                        // File does not exist
                        return false;
                    }
                    response.Close();
                }
                throw; // Rethrow other exceptions
            }
        }

        private async Task DeleteFileAsync(string fileUrl, string username, string password)
        {
            try
            {
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(fileUrl);
                request.Credentials = new NetworkCredential(username, password);
                request.Method = WebRequestMethods.Ftp.DeleteFile;
                request.Timeout = 2400000; // Increased timeout
                request.ReadWriteTimeout = 2400000; // Increased read/write timeout

                using (FtpWebResponse response = (FtpWebResponse)await request.GetResponseAsync())
                {
                    // If file deletion is successful, status code will be 'FileActionOK'
                    if (response.StatusCode != FtpStatusCode.FileActionOK)
                    {
                        // throw new InvalidOperationException("Failed to delete file: {response.StatusDescription}");
                    }
                }
            }
            catch (WebException ex)
            {
                if (ex.Response is FtpWebResponse response)
                {
                    // Log the status code if file deletion fails
                    // Console.WriteLine(
                    //     $"Error: {response.StatusCode} - {response.StatusDescription}"
                    // );
                    response.Close();
                }
                // Rethrow the exception so calling code can handle it
                // throw new InvalidOperationException("Failed to delete file", ex);
            }
        }

        [HttpGet("LoadDocumentCategories")]
        public IActionResult LoadDocumentCategories()
        {
            log.Debug("LoadDocumentCategories  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<DocumentCategories>? RequestsList = adapter.DocumentCategories();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for load documents - Error:" + ex.Message);
                return NotFound("No results");
            }
        }
        [HttpGet("GetProcedures")]
        public IActionResult GetProcedures()
        {
            log.Debug("GetProcedures  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetProcedures();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for load documents - Error:" + ex.Message);
                return NotFound("No results");
            }
        }


        [HttpGet("LoadDocumentTypes")]
        public IActionResult LoadDocumentTypes()
        {
            log.Debug("LoadDocumentTypes  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.LoadDocumentTypes();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for LoadDocumentTypes - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetConfigValues")]
        public IActionResult GetConfigValues(int CompanyId)
        {
            log.Debug("GetConfigValues  ==> ");
            try
            {
                string DatabaseName = _appSettings.ConnectionString;
                _appSettings.ConnectionString = _appSettings.AdminConnectionString;
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.ConfigValues(CompanyId, DatabaseName);
                _appSettings.ConnectionString = DatabaseName;
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for GetConfigValues - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetSpecialities")]
        public IActionResult GetSpecialities()
        {
            log.Debug("GetSpecialities  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<Specialities>? RequestsList = adapter.Specialities();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for specialities - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetPatientDocuments")]
        public IActionResult GetPatientDocuments(int SPatientID, int SLocationID, int SAppointmentID, int SAdmissionID, int SDocID, string SDueFrom, string SDueTO)
        {
            log.Debug("GetPatientDocuments  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.PatientDocuments(SPatientID, SLocationID, SAppointmentID, SAdmissionID, SDocID, SDueFrom, SDueTO);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for patient documents - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetPatientAdmissions")]
        public IActionResult GetPatientAdmissions(int SPatientID)
        {
            log.Debug("GetPatientAdmissions  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<Admissions>? RequestsList = adapter.PatientAdmissions(SPatientID);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for patient documents - Error:" + ex.Message);
                return NotFound("No results");
            }
        }
        [HttpGet("GetAdmissionDischargeData")]
        public IActionResult GetAdmissionDischargeData(int SndAdmissionID,int SndIsOldData)
        {
            log.Debug("GetPatientAdmissions  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.AdmissionDischargeData(SndAdmissionID,SndIsOldData);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get GetAdmissionDischargeData - Error:" + ex.Message);
                return NotFound("No results");
            }
        }
        // [HttpPost("SavePatientDocument")]
        // public int SavePatientDocument_bkp([FromBody] PatientDocumentDetailsModel model)
        // {
        //     log.Debug("SavePatientDocument  ==> ");
        //     int SavePT = 0;
        //     try
        //     {
        //         FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
        //         SavePT = adapter.SavePatientDocumentData(model);
        //     }
        //     catch (Exception ex)
        //     {
        //         log.Error("Fail to get data for save patient documents - Error:" + ex.Message);
        //     }
        //     return SavePT;
        // }

        [HttpPost("UpdateImageCategory")]
        public int UpdateImageCategory(int sndPatDocId, int sndDocTypeId, int sndUserID)
        {
            int savedCount = 0;
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                savedCount = adapter.UpdateImageCategory(sndPatDocId, sndDocTypeId, sndUserID);
            }
            catch (Exception ex)
            {
                log.Error("UpdateImageCategory -> Failed to save documents - Error: " + ex.Message);
            }
            return savedCount;
        }

        [HttpPost("UpdateImageSortNo")]
        public int UpdateImageSortNo([FromBody] PatientImgDocSort PatImgDoc)
        {
            int savedCount = 0;
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                savedCount = adapter.UpdateImageSortNo(PatImgDoc);
            }
            catch (Exception ex)
            {
                log.Error("UpdateImageSortNo -> Failed to save documents - Error: " + ex.Message);
            }
            return savedCount;
        }


        [HttpPost("SavePatientDocument")]
        public int SavePatientDocumentData([FromBody] List<PatientDocumentDetailsModel> models)
        {
            log.Debug("SaveMultiplePatientDocuments  ==> Received " + models.Count + " records.");
            int savedCount = 0;
            try
            {
                if (models == null || models.Count == 0)
                {
                    log.Warn("SaveMultiplePatientDocuments => No data received.");
                    return 0;
                }

                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                savedCount = adapter.SavePatientDocumentData(models);
            }
            catch (Exception ex)
            {
                log.Error("SaveMultiplePatientDocuments -> Failed to save documents - Error: " + ex.Message);
            }
            return savedCount;
        }

        [HttpPost("SaveAdmissionDischargeData")]
        public IActionResult SaveAdmissionDischargeData([FromBody] List<AdmissionDischargeModel> models)
        {
            if (models == null || models.Count == 0)
            {
                log.Warn("SaveAdmissionDischargeData => No data received.");
                return BadRequest("No data received.");
            }

            log.Debug("SaveAdmissionDischargeData ==> Received " + models.Count + " records.");

            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                int savedCount = adapter.SaveAdmissionDischargeData(models);

                log.Info($"SaveAdmissionDischargeData => Successfully saved {savedCount} records.");
                return Ok(savedCount);
            }
            catch (Exception ex)
            {
                log.Error("SaveAdmissionDischargeData -> Failed to save data - " + ex.Message);
                return StatusCode(500, "Internal server error");
            }


        }



        // [HttpPost("SaveAdmissionDischargeData")]
        // public int SaveAdmissionDischargeData(int MRDId, int ProviderId, int DepartmentId, int AdmissionAge, string AdmissionDate,int AdmissionTypeId, string DischargeDate, 
        // int DischargeTypeId, string Cause, int UserId,string MRD_Wards, string MRD_ICDS, string MRD_Procedures)
        // {
        //     log.Debug("SaveAdmissionDischargeData ==> Received request.");

        //     int savedCount = 0;
        //     try
        //     {
        //         FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
        //         savedCount = adapter.SaveAdmissionDischargeData(
        //             MRDId, ProviderId, DepartmentId, AdmissionAge, AdmissionDate,
        //             AdmissionTypeId, DischargeDate, DischargeTypeId, Cause, UserId,
        //             MRD_Wards, MRD_ICDS, MRD_Procedures);

        //         log.Info($"SaveAdmissionDischargeData => Successfully saved {savedCount} records.");
        //     }
        //     catch (Exception ex)
        //     {
        //         log.Error("SaveAdmissionDischargeData -> Failed to save data - " + ex.Message);
        //     }

        //     return savedCount;
        // }

        [HttpGet("GetUserLocations")]
        public IActionResult GetUserLocations(string sndUserName)
        {
            log.Debug("GetLocations  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetUserLocations(sndUserName);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data  GetUserLocations - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetDepartments")]
        public IActionResult GetDepartments(int sndLocationId)
        {
            log.Debug("GetLocations  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetDepartments(sndLocationId);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data  GetDepartments - Error:" + ex.Message);
                return NotFound("No results");
            }
        }
        [HttpGet("GetWards")]
        public IActionResult GetWards(int sndLocationId)
        {
            log.Debug("GetWards  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetWards(sndLocationId);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data  GetWards - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetAdmissionTypes")]
        public IActionResult GetAdmissionTypes()
        {
            log.Debug("GetAdmissionTypes  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetAdmissionTypes();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data  GetAdmissionTypes - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetDischargeTypes")]
        public IActionResult GetDischargeTypes()
        {
            log.Debug("GetDischargeTypes  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.GetDischargeTypes();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data  GetDischargeTypes - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("LoadICD")]
        public IActionResult LoadICD()
        {
            log.Debug("LoadICD  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<object>? RequestsList = adapter.LoadICD();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data  LoadICD - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        // [HttpPost("DeletePatientDocument")]
        // public int DeletePatientDocument(int DocumentID)
        // {
        //     log.Debug("DeletePatientDocument  ==> ");
        //     int DeletePT = 0;
        //     try
        //     {
        //         FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
        //         DeletePT = adapter.DeletePatientDocumentData(DocumentID);
        //     }
        //     catch (Exception ex)
        //     {
        //         log.Error("Fail to get data for delete patient documents - Error:" + ex.Message);
        //     }
        //     return DeletePT;
        // }

        [HttpPost("DeletePatientDocument")]
        public string DeletePatientDocument(int AdmissionId, int DocumentID, int UserID,int SndIsOldData)
        {
            log.Debug("DeletePatientDocument  ==> ");
            string DeletePT = "";
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                DeletePT = adapter.DeletePatientDocumentData(AdmissionId, DocumentID, UserID,SndIsOldData);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for delete patient documents - Error:" + ex.Message);
            }
            return DeletePT;
        }

        [HttpGet("IsValidUser")]
        public bool IsValidUser(string SndUserName, string SndPassword)
        {
            log.Debug("IsValidUser  ==> ");
            bool _isValid = false;
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                _isValid = adapter.IsValidUserData(SndUserName, SndPassword);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for IsValidUser - Error:" + ex.Message);
            }
            return _isValid;
        }

        [HttpPost("DownloadBase64DataAsync")]
        public async Task<string> DownloadBase64DataAsync(string fileNameWithPath, bool IsExternal)
        {
            bool isFTPMODE = _appSettings.FTPConfiguration.FTPMODE;
            var base64 = string.Empty;
            if (IsExternal == true)
            {
                int bytesRead;
                // byte[] buffer = new byte[2048];
                byte[] buffer = new byte[1048576]; // 1 MB buffer
                byte[] fileData = null;

                string FTPURL = _appSettings.FTPConfiguration.FtpURL.ToString() + '/' + _appSettings.FTPConfiguration.DestinationPathFtp.ToString();
                string FTPUserName = _appSettings.FTPConfiguration.Username.ToString();
                string FTPPassword = _appSettings.FTPConfiguration.Password.ToString();

                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(FTPURL + fileNameWithPath);
                request.Method = WebRequestMethods.Ftp.DownloadFile;
                request.Credentials = new NetworkCredential(FTPUserName, FTPPassword);
                try
                {
                    Stream reader = request.GetResponse().GetResponseStream();
                    using (MemoryStream ms = new MemoryStream())
                    {
                        while (true)
                        {
                            bytesRead = await reader.ReadAsync(buffer, 0, buffer.Length);
                            if (bytesRead == 0)
                                break;
                            ms.Write(buffer, 0, bytesRead);
                        }
                        fileData = ms.ToArray();
                    }
                    reader.Close();
                    base64 = Convert.ToBase64String(fileData);
                }
                catch (WebException ex)
                {
                    FtpWebResponse response = (FtpWebResponse)ex.Response;
                    if (response.StatusCode == FtpStatusCode.ActionNotTakenFileUnavailable)
                    {
                        response.Close();
                    }
                    return null;
                }
            }
            else
            {
                string strDestinationPath = _appSettings
                    .FTPConfiguration.DestinationPathFile.ToString()
                    .Trim();
                string strFullPath = Path.Combine(strDestinationPath, fileNameWithPath);
                if (string.IsNullOrEmpty(strFullPath) || !System.IO.File.Exists(strFullPath))
                {
                    return "File not found";
                }

                byte[] fileBytes = await System.IO.File.ReadAllBytesAsync(strFullPath);
                base64 = Convert.ToBase64String(fileBytes);
            }
            return base64;
        }

        [HttpPost("DownloadBase64DataAsync_New")]
        public IActionResult DownloadBase64DataAsync_New(string fileNameWithPath)
        {
            string strDestinationPath = _appSettings.FTPConfiguration.DestinationPathFile.ToString().Trim();
            string strMfN = fileNameWithPath.Replace("/", "\\").TrimStart('\\');
            string strFullPath = Path.Combine(strDestinationPath, strMfN);

            if (string.IsNullOrEmpty(strFullPath) || !System.IO.File.Exists(strFullPath))
            {
                return BadRequest("File not found");
            }

            try
            {
                var fileStream = new FileStream(strFullPath, FileMode.Open, FileAccess.Read, FileShare.Read);
                var base64Stream = new Base64EncodingStream(fileStream);
                return new FileStreamResult(base64Stream, "application/octet-stream")
                {
                    FileDownloadName = Path.GetFileName(fileNameWithPath)
                };
            }
            catch (Exception ex)
            {
                return StatusCode(500, "Error processing file: " + ex.Message.ToString());
            }
        }

        [HttpGet("GetPDFBase64")]
        public async Task<string> GetPDFBase64(string remoteFilePath)
        {
            // string filePath = @"C:\Users\mohank\Desktop\FTP\9.pdf";
            byte[] fileBytes = System.IO.File.ReadAllBytes(remoteFilePath);

            string strbase64 = Convert.ToBase64String(fileBytes);
            return strbase64;
        }

        [HttpPost("DownloadBase64LargeFileAsync")]
        public async Task<string> DownloadBase64LargeFileAsync(string remoteFilePath)
        {
            // string filePath = @"C:\Users\mohank\Desktop\FTP\9.pdf";
            // byte[] fileBytes = System.IO.File.ReadAllBytes(filePath);
            // string strbase64=Convert.ToBase64String(fileBytes);
            // return strbase64;

            try
            {
                string _ftpUrl = _appSettings.FTPConfiguration.FtpURL.ToString();
                string _ftpUsername = _appSettings.FTPConfiguration.Username.ToString();
                string _ftpPassword = _appSettings.FTPConfiguration.Password.ToString();

                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(_ftpUrl + remoteFilePath);
                request.Method = WebRequestMethods.Ftp.DownloadFile;
                request.Credentials = new NetworkCredential(_ftpUsername, _ftpPassword);
                request.UseBinary = true;
                request.UsePassive = true;
                request.KeepAlive = true;
                request.Timeout = 2400000; // Increased timeout for large files (40 minutes)
                request.ReadWriteTimeout = 2400000; // Increased read/write timeout for large files

                using (FtpWebResponse response = (FtpWebResponse)await request.GetResponseAsync())
                {
                    using (Stream ftpStream = response.GetResponseStream())
                    {
                        // byte[] buffer = new byte[1024 * 8];
                        byte[] buffer = new byte[1048576]; // 1 MB buffer
                        int bytesRead;
                        using (MemoryStream memoryStream = new MemoryStream())
                        {
                            while (
                                (bytesRead = await ftpStream.ReadAsync(buffer, 0, buffer.Length))
                                > 0
                            )
                            {
                                await memoryStream.WriteAsync(buffer, 0, bytesRead);
                            }
                            byte[] fileData = memoryStream.ToArray();
                            string base64Encoded = Convert.ToBase64String(fileData);
                            return base64Encoded;
                        }
                    }
                }
            }
            catch (WebException ex)
            {
                return ex.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        [HttpPost("RenameFtpFile")]
        public async Task<bool> RenameFtpFile(string source, string destination)
        {
            string FTPURL = _appSettings.FTPConfiguration.FtpURL.ToString();
            string FTPUserName = _appSettings.FTPConfiguration.Username.ToString();
            string FTPPassword = _appSettings.FTPConfiguration.Password.ToString();

            Uri serverFile = new Uri(FTPURL + source);
            FtpWebRequest request = (FtpWebRequest)WebRequest.Create(serverFile);
            request.Method = WebRequestMethods.Ftp.Rename;
            request.UseBinary = true;
            request.Credentials = new NetworkCredential(FTPUserName, FTPPassword);
            request.RenameTo = "/" + destination;
            FtpWebResponse response = (FtpWebResponse)request.GetResponse();
            var success =
                response.StatusCode == FtpStatusCode.CommandOK
                || response.StatusCode == FtpStatusCode.FileActionOK;
            return success;
        }

        //Using for Scan upload


        [HttpPost("UploadProfileImageAsync")]
        public async Task<string> UploadProfileImageAsync(
            [FromBody] FileResponseModel model,
            string filePath
        )
        {
            if (string.IsNullOrEmpty(filePath) && string.IsNullOrEmpty(model.Base64String))
            {
                return "Should not be empty filePath and file..";
            }
            var imageBytes = ToImageBytes(model.Base64String);
            var imageStream = new MemoryStream(imageBytes);

            bool isFTPMODE = _appSettings.FTPConfiguration.FTPMODE;
            string uploadResponse = string.Empty;
            if (isFTPMODE == true)
            {
                uploadResponse = await this.UploadFileWithStreamAsync(
                    filePath.ToString().Trim(),
                    imageStream
                );
            }
            else
            {
                uploadResponse = await this.UploadFileWithStreamLocal(
                    filePath.ToString().Trim(),
                    imageStream
                );

                // uploadResponse = await this.UploadFileWithStreamToNetworkShare(
                //     filePath.ToString().Trim(),
                //     imageStream
                // );
            }
            return uploadResponse;
        }

        [HttpPost("UploadLargeFileWithStreamLocal")]
        public async Task<string> UploadLargeFileWithStreamLocal(string fileName, Stream stream)
        {
            if (stream == null)
            {
                throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
            }

            if (string.IsNullOrWhiteSpace(fileName))
            {
                throw new ArgumentNullException(
                    nameof(fileName),
                    "File name cannot be null or empty."
                );
            }

            string strDestinationPath = _appSettings
                .FTPConfiguration.DestinationPathFile.ToString()
                .Trim();
            string strMfN = fileName.Replace("/", "\\").TrimStart('\\');

            string strFullPath = Path.Combine(strDestinationPath, strMfN);
            string strDirectoryPath = Path.GetDirectoryName(strFullPath);

            // Ensure the directory exists
            if (!Directory.Exists(strDirectoryPath))
            {
                Directory.CreateDirectory(strDirectoryPath);
            }

            // If file already exists, delete it
            if (System.IO.File.Exists(strFullPath))
            {
                try
                {
                    System.GC.Collect();
                    System.IO.File.Delete(strFullPath);
                }
                catch (Exception ex)
                {
                    return "Error deleting existing file: " + ex.Message;
                }
            }

            string filePath = Path.Combine(strDirectoryPath, Path.GetFileName(strFullPath));

            const int bufferSize = 1048576; // 80 KB buffer, you can adjust the size based on your system
            byte[] buffer = new byte[bufferSize];

            try
            {
                using (var fileStream = new FileStream(filePath, FileMode.Create, FileAccess.Write))
                {
                    int bytesRead;
                    while ((bytesRead = await stream.ReadAsync(buffer, 0, buffer.Length)) > 0)
                    {
                        await fileStream.WriteAsync(buffer, 0, bytesRead);
                    }
                }
                return string.Empty;
            }
            catch (Exception ex)
            {
                return "Error uploading file: " + ex.Message;
            }
        }

        [HttpPost("UploadFileByPath")]
        public async Task<string> UploadFileByPath(string filePath)
        {
            if (string.IsNullOrWhiteSpace(filePath))
            {
                throw new ArgumentNullException(
                    nameof(filePath),
                    "File path cannot be null or empty."
                );
            }

            if (!System.IO.File.Exists(filePath))
            {
                throw new FileNotFoundException("The specified file does not exist.", filePath);
            }

            string strDestinationPath = _appSettings
                .FTPConfiguration.DestinationPathFile.ToString()
                .Trim();
            string strMfN = Path.GetFileName(filePath);
            string strFullPath = Path.Combine(strDestinationPath, strMfN);
            string strDirectoryPath = Path.GetDirectoryName(strFullPath);

            if (!Directory.Exists(strDirectoryPath))
            {
                Directory.CreateDirectory(strDirectoryPath);
            }

            if (System.IO.File.Exists(strFullPath))
            {
                try
                {
                    System.GC.Collect();
                    System.IO.File.Delete(strFullPath);
                }
                catch (Exception ex)
                {
                    return "Error deleting existing file: " + ex.Message;
                }
            }
            const int bufferSize = 81920;
            byte[] buffer = new byte[bufferSize];

            try
            {
                using (var sourceStream = new FileStream(filePath, FileMode.Open, FileAccess.Read))
                using (
                    var destinationStream = new FileStream(
                        strFullPath,
                        FileMode.Create,
                        FileAccess.Write
                    )
                )
                {
                    int bytesRead;
                    while ((bytesRead = await sourceStream.ReadAsync(buffer, 0, buffer.Length)) > 0)
                    {
                        await destinationStream.WriteAsync(buffer, 0, bytesRead);
                    }
                }
                return string.Empty;
            }
            catch (Exception ex)
            {
                return "Error uploading file: " + ex.Message;
            }
        }

        public async Task<string> UploadFileWithStreamLocal(string fileName, Stream stream)
        {
            if (stream == null)
            {
                throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
            }

            if (string.IsNullOrWhiteSpace(fileName))
            {
                throw new ArgumentNullException(
                    nameof(fileName),
                    "File name cannot be null or empty."
                );
            }

            string strDestinationPath = _appSettings
                .FTPConfiguration.DestinationPathFile.ToString()
                .Trim();
            string strMfN = fileName.Replace("/", "\\").TrimStart('\\');

            string strFullPath = Path.Combine(strDestinationPath, strMfN);
            string strDirectoryPath = Path.GetDirectoryName(strFullPath);

            if (!Directory.Exists(strDirectoryPath))
            {
                Directory.CreateDirectory(strDirectoryPath);
            }

            if (System.IO.File.Exists(strFullPath))
            {
                try
                {
                    System.GC.Collect();
                    // System.GC.WaitForPendingFinalizers();
                    System.IO.File.Delete(strFullPath);
                }
                catch (Exception ex)
                {
                    return "Error deleting existing file: " + ex.Message.ToString();
                }
            }

            string filePath = Path.Combine(strDirectoryPath, Path.GetFileName(strFullPath));

            try
            {
                using (var fileStream = new FileStream(filePath, FileMode.Create, FileAccess.Write))
                {
                    await stream.CopyToAsync(fileStream);
                }
                return string.Empty;
            }
            catch (Exception ex)
            {
                return ex.Message.ToString();
            }
        }

        [HttpPost("UploadFileWithFilePath")]
        public async Task<string> UploadFileWithFilePath(string fileName, string filePath)
        {
            if (string.IsNullOrWhiteSpace(filePath))
            {
                throw new ArgumentNullException(
                    nameof(filePath),
                    "File path cannot be null or empty."
                );
            }

            if (string.IsNullOrWhiteSpace(fileName))
            {
                throw new ArgumentNullException(
                    nameof(fileName),
                    "File name cannot be null or empty."
                );
            }

            string strDestinationPath = _appSettings
                .FTPConfiguration.DestinationPathFile.ToString()
                .Trim();
            string strMfN = fileName.Replace("/", "\\").TrimStart('\\');

            string strFullPath = Path.Combine(strDestinationPath, strMfN);
            string strDirectoryPath = Path.GetDirectoryName(strFullPath);

            if (!Directory.Exists(strDirectoryPath))
            {
                Directory.CreateDirectory(strDirectoryPath);
            }

            if (System.IO.File.Exists(strFullPath))
            {
                try
                {
                    System.GC.Collect();
                    System.IO.File.Delete(strFullPath);
                }
                catch (Exception ex)
                {
                    return "Error deleting existing file: " + ex.Message;
                }
            }

            // const int bufferSize = 81920; // 80KB buffer size
            const int bufferSize = 1048576; // 80KB buffer size
            byte[] buffer = new byte[bufferSize];

            try
            {
                using (var fileStream = new FileStream(filePath, FileMode.Open, FileAccess.Read))
                using (
                    var destinationStream = new FileStream(
                        strFullPath,
                        FileMode.Create,
                        FileAccess.Write
                    )
                )
                {
                    int bytesRead;
                    while ((bytesRead = await fileStream.ReadAsync(buffer, 0, buffer.Length)) > 0)
                    {
                        await destinationStream.WriteAsync(buffer, 0, bytesRead);
                    }
                }

                return string.Empty;
            }
            catch (Exception ex)
            {
                return ex.Message;
            }
        }

        public async Task<string> UploadFileWithStreamToNetworkShare(string fileName, Stream stream)
        {
            if (stream == null)
            {
                throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
            }

            if (string.IsNullOrWhiteSpace(fileName))
            {
                throw new ArgumentNullException(
                    nameof(fileName),
                    "File name cannot be null or empty."
                );
            }

            // Network share path
            string strDestinationPath = _appSettings
                .FTPConfiguration.DestinationPathFile.ToString()
                .Trim();

            // Replace forward slashes with backslashes for network path
            string strMfN = fileName.Replace("/", "\\").TrimStart('\\');

            string strFullPath = Path.Combine(strDestinationPath, strMfN);
            string strDirectoryPath = Path.GetDirectoryName(strFullPath);

            // if (strDestinationPath.StartsWith(@"\\"))
            if (true)
            {
                try
                {
                    var networkPath = strDestinationPath;
                    var networkCredential = new NetworkCredential(
                        "krishna",
                        "Krishna@123",
                        "ICREATECH"
                    );

                    using (new NetworkConnection(networkPath, networkCredential))
                    {
                        if (!Directory.Exists(strDirectoryPath))
                        {
                            Directory.CreateDirectory(strDirectoryPath);
                        }
                    }
                }
                catch (UnauthorizedAccessException uaEx)
                {
                    return "Access denied. Check permissions on the network share.";
                }
                catch (Exception ex)
                {
                    return "Error creating directory: " + ex.Message;
                }
            }
            else
            {
                if (!Directory.Exists(strDirectoryPath))
                {
                    Directory.CreateDirectory(strDirectoryPath);
                }
            }

            if (System.IO.File.Exists(strFullPath))
            {
                return "File already exists.";
            }

            string filePath = Path.Combine(strDirectoryPath, Path.GetFileName(strFullPath));

            try
            {
                using (var fileStream = new FileStream(filePath, FileMode.Create, FileAccess.Write))
                {
                    await stream.CopyToAsync(fileStream);
                }

                return string.Empty; // Success
            }
            catch (Exception ex)
            {
                return "Error while uploading the file: " + ex.Message;
            }
        }

        public static void CreateNetworkDirectory(
            string networkPath,
            string username,
            string password
        )
        {
            try
            {
                // Prepare the network credentials
                NetworkCredential credentials = new NetworkCredential(
                    username,
                    password,
                    "WORKGROUP"
                ); // Use the appropriate domain

                CredentialCache credentialCache = new CredentialCache();
                credentialCache.Add(new Uri(networkPath), "Basic", credentials);

                string testFilePath = Path.Combine(networkPath, "temp.txt");
                if (!System.IO.File.Exists(networkPath))
                {
                    System.IO.File.Create(testFilePath).Dispose();
                }

                if (!Directory.Exists(networkPath))
                {
                    Directory.CreateDirectory(networkPath);
                }
                else { }
            }
            catch (UnauthorizedAccessException ex)
            {
                // Console.WriteLine("Access denied. Please check your network permissions.");
                // Console.WriteLine($"Error: {ex.Message}");
            }
            catch (Exception ex)
            {
                // Console.WriteLine("An error occurred while creating the directory.");
                // Console.WriteLine($"Error: {ex.Message}");
            }
        }

        static string ConvertFtpUrlToLocalPath(string ftpUrl, string localRootPath)
        {
            Uri uri = new Uri(ftpUrl);
            string ftpPath = uri.AbsolutePath;
            if (!Directory.Exists(localRootPath))
            {
                Directory.CreateDirectory(localRootPath);
            }

            string localFilePath = Path.Combine(
                localRootPath,
                ftpPath.TrimStart('/').Replace('/', Path.DirectorySeparatorChar)
            );

            return localFilePath;
        }

        public async Task<string> UploadFileWithStreamAsync(string fileName, Stream stream)
        {
            if (stream == null)
            {
                throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
            }

            if (string.IsNullOrWhiteSpace(fileName))
            {
                throw new ArgumentNullException(
                    nameof(fileName),
                    "File name cannot be null or empty."
                );
            }

            string ftpUrl = _appSettings.FTPConfiguration.FtpURL.ToString();
            string ftpUserName = _appSettings.FTPConfiguration.Username.ToString();
            string ftpPassword = _appSettings.FTPConfiguration.Password.ToString();

            if (!ftpUrl.StartsWith("ftp://", StringComparison.OrdinalIgnoreCase))
            {
                throw new ArgumentException("FTP URL must start with ftp://", nameof(ftpUrl));
            }

            if (!ftpUrl.EndsWith("/"))
            {
                ftpUrl += "/";
            }

            string uploadUrl = ftpUrl + fileName;

            try
            {
                Uri uri = new Uri(uploadUrl);
                string strFolderPath = uri.AbsoluteUri.Substring(
                    0,
                    uri.AbsoluteUri.LastIndexOf('/')
                );
                if (CheckFolderExists(strFolderPath, ftpUserName, ftpPassword) == false)
                    CreateFolder(strFolderPath, ftpUserName, ftpPassword);

                // Check if the file already exists, and if so, delete it
                if (await FileExistsAsync(uploadUrl, ftpUserName, ftpPassword))
                {
                    await DeleteFileAsync(uploadUrl, ftpUserName, ftpPassword);
                }

                // Create the FTP request to upload the file
                FtpWebRequest ftp = (FtpWebRequest)WebRequest.Create(uploadUrl);
                ftp.Credentials = new NetworkCredential(ftpUserName, ftpPassword);
                ftp.KeepAlive = true;
                ftp.UseBinary = true;
                ftp.UsePassive = true;
                ftp.Method = WebRequestMethods.Ftp.UploadFile;
                ftp.Timeout = 2400000; // Increased timeout for large files (40 minutes)
                ftp.ReadWriteTimeout = 2400000; // Increased read/write timeout for large files

                // Upload the file in chunks
                using (Stream ftpStream = await ftp.GetRequestStreamAsync())
                {
                    byte[] buffer = new byte[1048576]; // 1 MB buffer
                    int bytesRead;
                    while ((bytesRead = await stream.ReadAsync(buffer, 0, buffer.Length)) > 0)
                    {
                        await ftpStream.WriteAsync(buffer, 0, bytesRead);
                    }
                }

                using (FtpWebResponse response = (FtpWebResponse)await ftp.GetResponseAsync())
                {
                    return ""; // Return empty string for successful upload
                }
            }
            catch (WebException ex)
            {
                if (ex.Response is FtpWebResponse response)
                {
                    response.Close();
                }
                return "Exception: " + ex.Message;
            }
            catch (Exception ex)
            {
                return "Exception: " + ex.Message;
            }
        }

        // public async Task<string> UploadFileWithStreamAsync(string fileName, Stream stream)
        // {
        //     if (stream == null)
        //     {
        //         throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
        //     }
        //     if (string.IsNullOrWhiteSpace(fileName))
        //     {
        //         throw new ArgumentNullException(
        //             nameof(fileName),
        //             "File name cannot be null or empty."
        //         );
        //     }

        //     string ftpUrl = _appSettings.FTPConfiguration.FtpURL.ToString();
        //     string ftpUserName = _appSettings.FTPConfiguration.Username.ToString();
        //     string ftpPassword = _appSettings.FTPConfiguration.Password.ToString();

        //     if (!ftpUrl.StartsWith("ftp://", StringComparison.OrdinalIgnoreCase))
        //     {
        //         throw new ArgumentException("FTP URL must start with ftp://", nameof(ftpUrl));
        //     }

        //     if (!ftpUrl.EndsWith("/"))
        //     {
        //         ftpUrl += "/";
        //     }

        //     string uploadUrl = ftpUrl + fileName;

        //     try
        //     {
        //         Uri uri = new Uri(uploadUrl);
        //         string strFolderPath = uri.AbsoluteUri.Substring(
        //             0,
        //             uri.AbsoluteUri.LastIndexOf('/')
        //         );
        //         if (!CheckFolderExists(strFolderPath, ftpUserName, ftpPassword))
        //         {
        //             CreateFolder(strFolderPath, ftpUserName, ftpPassword);
        //         }

        //         FtpWebRequest ftp = (FtpWebRequest)WebRequest.Create(uploadUrl);
        //         ftp.Credentials = new NetworkCredential(ftpUserName, ftpPassword);
        //         ftp.KeepAlive = true;
        //         ftp.UseBinary = true; // Ensure binary mode for PDFs
        //         ftp.UsePassive = true; // Use passive mode for better firewall compatibility
        //         ftp.Method = WebRequestMethods.Ftp.UploadFile;


        //         // Set high timeout values to ensure file upload completion
        //         ftp.Timeout = 2400000; // Increased timeout for large files (40 minutes)
        //         ftp.ReadWriteTimeout = 2400000; // Increased read/write timeout for large files

        //         // Choose an appropriate buffer size for large files (e.g., 512 KB buffer)
        //         byte[] buffer = new byte[1048576]; // 1 MB buffer
        //         int bytesRead;
        //         long totalBytesUploaded = 0;

        //         using (Stream ftpStream = await ftp.GetRequestStreamAsync())
        //         {
        //             while ((bytesRead = await stream.ReadAsync(buffer, 0, buffer.Length)) > 0)
        //             {
        //                 await ftpStream.WriteAsync(buffer, 0, bytesRead);
        //                 totalBytesUploaded += bytesRead;
        //             }
        //         }

        //         using (FtpWebResponse response = (FtpWebResponse)await ftp.GetResponseAsync())
        //         {
        //             // Console.WriteLine($"FTP Response: {response.StatusCode}");
        //             if (response.StatusCode == FtpStatusCode.ClosingData)
        //             {
        //                 return ""; // Success
        //             }
        //             else
        //             {
        //                 return response.StatusDescription; // Return status description if not successful
        //             }
        //         }
        //     }
        //     catch (WebException ex)
        //     {
        //         if (ex.Response is FtpWebResponse response)
        //         {
        //             using (response)
        //             {
        //                 return "FTP Error: " + response.StatusDescription;
        //             }
        //         }
        //         return "WebException: " + ex.Message;
        //     }
        //     catch (Exception ex)
        //     {
        //         return "Exception: " + ex.Message;
        //     }
        // }

        // public static byte[] ToImageBytes(string image) =>
        //     !string.IsNullOrEmpty(image)
        //         ? Convert.FromBase64String(
        //             Regex.Replace(
        //                 image,
        //                 "data:image/(png|jpg|PNG|JPG|JPEG|jpeg|gif|GIF|bmp|BMP);base64,",
        //                 string.Empty
        //             )
        //         )
        //         : null;

        public static byte[] ToImageBytes(string image)
        {
            if (string.IsNullOrEmpty(image))
                return null;

            try
            {
                // Remove the data:image part (if it exists) using a regex
                string base64String = Regex.Replace(
                    image,
                    @"^data:image\/(png|jpg|jpeg|gif|bmp);base64,",
                    string.Empty,
                    RegexOptions.IgnoreCase
                );

                // Decode the base64 string to bytes
                return Convert.FromBase64String(base64String);
            }
            catch (FormatException ex)
            {
                // Catch any base64 errors
                Console.WriteLine("Invalid base64 string: " + ex.Message);
                return null;
            }
        }

        [HttpPost("DeleteFTPFile")]
        public async Task<string> DeleteFTPFile(string fileNameWithDestinationPath)
        {
            bool isFTPMODE = _appSettings.FTPConfiguration.FTPMODE;
            string result = string.Empty;

            if (isFTPMODE == true)
            {
                result = await DeleteFileFTPAsync(fileNameWithDestinationPath);
            }
            else
            {
                result = await DeleteFileLocallyAsync(fileNameWithDestinationPath);
            }
            return result;
        }

        private async Task<string> DeleteFileFTPAsync(string sourceFilePath)
        {
            try
            {
                string FTPURL = _appSettings.FTPConfiguration.FtpURL.ToString();
                string FTPUserName = _appSettings.FTPConfiguration.Username.ToString();
                string FTPPassword = _appSettings.FTPConfiguration.Password.ToString();
                string strSourceFullPath = "";
                string strBasePath = _appSettings
                 .FTPConfiguration.DestinationPathFtp.ToString()
                 .Trim();
                sourceFilePath = sourceFilePath.Replace("/", "\\").TrimStart('\\');
                strSourceFullPath = Path.Combine(strBasePath, sourceFilePath);

                FtpWebRequest ftp = (FtpWebRequest)
                    WebRequest.Create(FTPURL + strSourceFullPath);
                ftp.Credentials = new NetworkCredential(FTPUserName, FTPPassword);
                ftp.KeepAlive = true;
                ftp.UseBinary = true;
                ftp.UsePassive = true;
                ftp.Method = WebRequestMethods.Ftp.DeleteFile;
                FtpWebResponse response = (FtpWebResponse)await ftp.GetResponseAsync();
                var statuscode = (int)response.StatusCode;
                response.Close();
                return "";
            }
            catch (WebException ex)
            {
                return "Error deleting file: " + ex.Message.ToString();
            }
        }

        private async Task<string> DeleteFileLocallyAsync(string sourceFilePath)
        {
            string strSourceFullPath = "";
            try
            {
                string strBasePath = _appSettings
                    .FTPConfiguration.DestinationPathFile.ToString()
                    .Trim();

                sourceFilePath = sourceFilePath.Replace("/", "\\").TrimStart('\\');
                strSourceFullPath = Path.Combine(strBasePath, sourceFilePath);

                if (!System.IO.File.Exists(strSourceFullPath))
                {
                    return "Source file does not exist.";
                }
                System.IO.File.Delete(strSourceFullPath);
                return "";
            }
            catch (Exception ex)
            {
                return "Error deleting file: " + ex.Message;
            }
        }

        public bool CheckIfFileExistsOnServer(string fileName)
        {
            string FTPURL = _appSettings.FTPConfiguration.FtpURL.ToString();
            string FTPUserName = _appSettings.FTPConfiguration.Username.ToString();
            string FTPPassword = _appSettings.FTPConfiguration.Password.ToString();

            var request = (FtpWebRequest)WebRequest.Create(FTPURL + fileName);
            request.Credentials = new NetworkCredential(FTPUserName, FTPPassword);
            request.Method = WebRequestMethods.Ftp.GetFileSize;
            request.KeepAlive = true;
            request.UseBinary = true;
            request.UsePassive = true;
            try
            {
                var response = (FtpWebResponse)request.GetResponse();
                response.Close();
                return true;
            }
            catch (WebException ex)
            {
                FtpWebResponse response = (FtpWebResponse)ex.Response;
                if (response.StatusCode == FtpStatusCode.ActionNotTakenFileUnavailable)
                {
                    response.Close();
                    return false;
                }
                response.Close();
            }
            return false;
        }

        public bool CheckFolderExists(string folderName, string username, string password)
        {
            try
            {
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(folderName);
                request.Credentials = new NetworkCredential(username, password);
                request.Method = WebRequestMethods.Ftp.ListDirectory;
                using (FtpWebResponse response = (FtpWebResponse)request.GetResponse())
                {
                    return true;
                }
            }
            catch (WebException ex)
            {
                FtpWebResponse response = (FtpWebResponse)ex.Response;
                if (response.StatusCode == FtpStatusCode.ActionNotTakenFileUnavailable)
                {
                    return false;
                }
                else
                {
                    return false;
                }
            }
        }

        public bool CreateFolder(string folderName, string username, string password)
        {
            try
            {
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(folderName);
                request.Credentials = new NetworkCredential(username, password);
                request.Method = WebRequestMethods.Ftp.MakeDirectory;
                using (FtpWebResponse response = (FtpWebResponse)request.GetResponse())
                {
                    return true;
                }
            }
            catch (WebException ex)
            {
                return false;
            }
        }

        // [HttpPost("UploadProfileImageAsyncLargeFiles")]
        // public async Task<string> UploadProfileImageAsyncLargeFiles(
        //     [FromBody] FileResponseModel model,
        //     string filePath
        // )
        // {
        //     if (string.IsNullOrEmpty(filePath) && string.IsNullOrEmpty(model.Base64String))
        //     {
        //         return "Should not be empty filePath and file..";
        //     }
        //     var imageBytes = ToImageBytes(model.Base64String);
        //     var imageStream = new MemoryStream(imageBytes);
        //     var uploadResponse = await this.UploadFileWithStreamAsync_New(filePath, imageStream);
        //     return uploadResponse;
        // }

        // public async Task<string> UploadFileWithStreamAsync_New(string fileName, Stream stream)
        // {
        //     if (stream == null)
        //     {
        //         throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
        //     }
        //     if (string.IsNullOrWhiteSpace(fileName))
        //     {
        //         throw new ArgumentNullException(
        //             nameof(fileName),
        //             "File name cannot be null or empty."
        //         );
        //     }

        //     string ftpUrl = _appSettings.FTPConfiguration.FtpURL.ToString();
        //     string ftpUserName = _appSettings.FTPConfiguration.Username.ToString();
        //     string ftpPassword = _appSettings.FTPConfiguration.Password.ToString();

        //     // Ensure the URL starts with "ftp://" and ends with a slash
        //     if (!ftpUrl.StartsWith("ftp://", StringComparison.OrdinalIgnoreCase))
        //     {
        //         throw new ArgumentException("FTP URL must start with ftp://", nameof(ftpUrl));
        //     }

        //     if (!ftpUrl.EndsWith("/"))
        //     {
        //         ftpUrl += "/";
        //     }

        //     string uploadUrl = ftpUrl + fileName;

        //     try
        //     {
        //         // Extract the FTP server host from the FTP URL
        //         Uri uri = new Uri(uploadUrl);
        //         string ftpHost = uri.Host;

        //         // Create an FTP client using FluentFTP
        //         using (
        //             FluentFTP.FtpClient ftpClient = new FluentFTP.FtpClient(
        //                 ftpHost,
        //                 new NetworkCredential(ftpUserName, ftpPassword)
        //             )
        //         )
        //         {
        //             // Connect to the FTP server asynchronously
        //             await ftpClient.ConnectAsync();

        //             // Extract the folder path (directory) from the URL (excluding the protocol part and file name)
        //             string remoteFolderPath = uri.AbsolutePath;

        //             // Normalize the path: replace backslashes with forward slashes
        //             remoteFolderPath = remoteFolderPath.Replace("\\", "/");


        //             // Remove the file name from the path, leaving only the directory portion
        //             remoteFolderPath = Path.GetDirectoryName(remoteFolderPath);

        //             // Ensure the folder path ends with a slash
        //             if (!remoteFolderPath.EndsWith("/"))
        //             {
        //                 remoteFolderPath += "/";
        //             }

        //             // Log the path for debugging
        //             Console.WriteLine($"Checking if directory exists: {remoteFolderPath}");

        //             // Check if the directory exists
        //             bool directoryExists = await ftpClient.DirectoryExistsAsync(remoteFolderPath);

        //             if (directoryExists)
        //             {
        //                 Console.WriteLine("Directory exists.");
        //             }
        //             else
        //             {
        //                 Console.WriteLine("Directory does not exist.");
        //             }

        //             // If the directory does not exist, create it
        //             if (!directoryExists)
        //             {
        //                 await ftpClient.CreateDirectoryAsync(remoteFolderPath);
        //                 Console.WriteLine("Directory created.");
        //             }

        //             // Upload the file to the FTP server
        //             FtpStatus uploadStatus = await ftpClient.UploadAsync(
        //                 stream,
        //                 fileName,
        //                 FtpRemoteExists.Overwrite
        //             );

        //             // Check if the upload was successful
        //             if (uploadStatus == FtpStatus.Success)
        //             {
        //                 return "";
        //             }
        //             else
        //             {
        //                 return "File upload failed. Status: " + uploadStatus.ToString();
        //             }
        //         }
        //     }
        //     catch (FtpException ex)
        //     {
        //         return "FTP Error: " + ex.Message;
        //     }
        //     catch (Exception ex)
        //     {
        //         return "Exception: " + ex.Message;
        //     }
        // }

        [HttpPost("MoveFileAsync")]
        public async Task<string> MoveFileAsync(string sourceFilePath, string destinationFilePath)
        {
            if (
                string.IsNullOrWhiteSpace(sourceFilePath)
                || string.IsNullOrWhiteSpace(destinationFilePath)
            )
            {
                return "Source and destination file paths cannot be null or empty.";
            }

            bool isFTPMODE = _appSettings.FTPConfiguration.FTPMODE; // Check the FTP mode setting
            string result = string.Empty;

            try
            {
                if (isFTPMODE) // FTP Mode
                {
                    // If FTP Mode is enabled, you can implement FTP file transfer logic
                    //result = await MoveFileToFtpAsync(sourceFilePath, destinationFilePath);
                    result = await MoveFileLocallyAsync(sourceFilePath, destinationFilePath);
                }
                else // Local File Mode
                {
                    // In Local File Mode, perform the file move locally
                    result = await MoveFileLocallyAsync(sourceFilePath, destinationFilePath);
                }

                return result;
            }
            catch (Exception ex)
            {
                return "Error moving file: " + ex.Message;
            }
        }

        private async Task<string> MoveFileLocallyAsync(
            string sourceFilePath,
            string destinationFilePath
        )
        {
            string strSourceFullPath = "";
            string strDestinationFullPath = "";
            try
            {
                string strBasePath = _appSettings
                    .FTPConfiguration.DestinationPathFile.ToString()
                    .Trim();

                sourceFilePath = sourceFilePath.Replace("/", "\\").TrimStart('\\');
                destinationFilePath = destinationFilePath.Replace("/", "\\").TrimStart('\\');

                strSourceFullPath = Path.Combine(strBasePath, sourceFilePath);
                strDestinationFullPath = Path.Combine(strBasePath, destinationFilePath);

                // string strDestinationDirectory = Path.GetDirectoryName(strDestinationFullPath);

                // Ensure the source file exists
                if (!System.IO.File.Exists(strSourceFullPath))
                {
                    return "Source file does not exist.";
                }
                if (!Directory.Exists(strDestinationFullPath))
                {
                    Directory.CreateDirectory(strDestinationFullPath);
                }

                strDestinationFullPath = Path.Combine(
                    strDestinationFullPath,
                    Path.GetFileName(strSourceFullPath)
                );
                // Move the file from source to destination
                System.IO.File.Move(strSourceFullPath, strDestinationFullPath);

                return ""; // Return empty string if move was successful
            }
            catch (Exception ex)
            {
                return "Error moving file : " + ex.Message;
            }
        }

        // private async Task<string> MoveFileToFtpAsync(string sourceFilePath, string destinationFilePath)
        // {
        //     try
        //     {
        //         // FTP file move logic will go here
        //         // Example: Upload the file to FTP and delete the source file after upload

        //         var ftpClient = new FtpClient( _appSettings.FTPConfiguration.FtpURL,_appSettings.FTPConfiguration.Username, _appSettings.FTPConfiguration.Password); //_appSettings.FTPConfiguration.ServerUrl,

        //         // Upload the file to FTP (assuming you have an FTP client setup)
        //         bool uploadResult = await ftpClient.UploadFileAsync(sourceFilePath, destinationFilePath);
        //         if (!uploadResult)
        //         {
        //             return "Error uploading file to FTP.";
        //         }

        //         // Once uploaded, delete the source file locally if the upload is successful
        //         if (System.IO.File.Exists(sourceFilePath))
        //         {
        //             System.IO.File.Delete(sourceFilePath);
        //         }

        //         return string.Empty; // Return empty string if move was successful
        //     }
        //     catch (Exception ex)
        //     {
        //         return "Error moving file to FTP: " + ex.Message;
        //     }
        // }




        public void WriteLog(string SndException)
        {
            string strfname = Convert.ToString(DateTime.Today.ToString("yyyy-MM-dd"));
            string strDirectory =
                System
                    .IO.Path.GetDirectoryName(
                        System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase
                    )
                    .Replace("file:\\", "") + "\\LOGDetails";
            string strFile =
                System
                    .IO.Path.GetDirectoryName(
                        System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase
                    )
                    .Replace("file:\\", "")
                + "\\LOGDetails\\"
                + strfname
                + ".txt";
            if (!System.IO.Directory.Exists(strDirectory))
            {
                System.IO.Directory.CreateDirectory(strDirectory);
            }

            StreamWriter objStreamWriter = default(StreamWriter);
            if (!System.IO.File.Exists(strFile))
            {
                FileStream fs = new FileStream(strFile, FileMode.Create, FileAccess.Write);
                objStreamWriter = new StreamWriter(fs);
                objStreamWriter.BaseStream.Seek(0, SeekOrigin.End);
            }
            else
            {
                objStreamWriter = System.IO.File.AppendText(strFile);
            }

            objStreamWriter.WriteLine(SndException);
            objStreamWriter.Close();
        }
    }
}
