using System;
using System.IO;
using System.Net;
using System.Runtime.InteropServices;

public class NetworkConnection : IDisposable
{
    private string _networkName;
    private NetworkCredential _credentials;

    [DllImport("mpr.dll")]
    private static extern int WNetAddConnection2(ref NetResource netResource, string password, string username, int flags);

    [DllImport("mpr.dll")]
    private static extern int WNetCancelConnection2(string name, int flags, bool force);

    [StructLayout(LayoutKind.Sequential)]
    public class NetResource
    {
        public int dwScope;
        public int dwType;
        public int dwDisplayType;
        public int dwUsage;
        public string lpLocalName;
        public string lpRemoteName;
        public string lpComment;
        public string lpProvider;
    }

    public NetworkConnection(string networkName, NetworkCredential credentials)
    {
        _networkName = networkName;
        _credentials = credentials;

        Connect();
    }

    private void Connect()
    {
        NetResource networkResource = new NetResource
        {
            dwType = 1, // Disk
            lpRemoteName = _networkName
        };

        int result = WNetAddConnection2(ref networkResource, _credentials.Password, _credentials.UserName, 0);
        if (result != 0)
        {
            throw new UnauthorizedAccessException("Could not connect to network drive.");
        }
    }

    public void Dispose()
    {
        WNetCancelConnection2(_networkName, 0, true);
    }
}
