using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Net;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using FTP_Services.Core.Models;
using FTP_Services.Services;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Options;

namespace FTP_Services.Services.Controllers
{
    public class FTPManagementAPIController : BaseAPIController
    {
        private readonly AppSettings _appSettings;

        public FTPManagementAPIController(IOptions<AppSettings> appSettings)
            : base(appSettings.Value)
        {
            log.Info("FTPManagementAPIController : Constractor");
            _appSettings = appSettings.Value;
        }

        [HttpPost("GetLoginDetails")]
        public IActionResult GetLoginDetails([FromBody] LoginResponseModel model)
        {
            log.Debug("GetLoginDetails  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<Login>? RequestsList = adapter.LoginData(model.UserName);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for login - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetSearchedPatients")]
        public IActionResult GetSearchedPatients(string SearchText)
        {
            log.Debug("GetSearchedPatients  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                // List<SearchPatients>? RequestsList = adapter.SearchedPatientsData(SearchText);
                List<object>? RequestsList = adapter.SearchedPatientsData(SearchText);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for search patients - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("LoadDocumentCategories")]
        public IActionResult LoadDocumentCategories()
        {
            log.Debug("LoadDocumentCategories  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<DocumentCategories>? RequestsList = adapter.DocumentCategories();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for load documents - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetSpecialities")]
        public IActionResult GetSpecialities()
        {
            log.Debug("GetSpecialities  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<Specialities>? RequestsList = adapter.Specialities();
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for specialities - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpGet("GetPatientDocuments")]
        public IActionResult GetPatientDocuments(int SPatientID, int SDocID)
        {
            log.Debug("GetPatientDocuments  ==> ");
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                List<PatientDocuments>? RequestsList = adapter.PatientDocuments(SPatientID, SDocID);
                return Ok(RequestsList);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for patient documents - Error:" + ex.Message);
                return NotFound("No results");
            }
        }

        [HttpPost("SavePatientDocument")]
        public int SavePatientDocument([FromBody] PatientDocumentDetailsModel model)
        {
            log.Debug("SavePatientDocument  ==> ");
            int SavePT = 0;
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                SavePT = adapter.SavePatientDocumentData(model);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for save patient documents - Error:" + ex.Message);
            }
            return SavePT;
        }

        // [HttpPost("DeletePatientDocument")]
        // public int DeletePatientDocument(int DocumentID)
        // {
        //     log.Debug("DeletePatientDocument  ==> ");
        //     int DeletePT = 0;
        //     try
        //     {
        //         FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
        //         DeletePT = adapter.DeletePatientDocumentData(DocumentID);
        //     }
        //     catch (Exception ex)
        //     {
        //         log.Error("Fail to get data for delete patient documents - Error:" + ex.Message);
        //     }
        //     return DeletePT;
        // }

        [HttpPost("DeletePatientDocument")]
        public string DeletePatientDocument(int DocumentID)
        {
            log.Debug("DeletePatientDocument  ==> ");
            string DeletePT = "";
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                DeletePT = adapter.DeletePatientDocumentData(DocumentID);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for delete patient documents - Error:" + ex.Message);
            }
            return DeletePT;
        }

        [HttpGet("IsValidUser")]
        public bool IsValidUser(string SndUserName, string SndPassword)
        {
            log.Debug("IsValidUser  ==> ");
            bool _isValid = false;
            try
            {
                FTPDataAdapter adapter = new FTPDataAdapter(_appSettings);
                _isValid = adapter.IsValidUserData(SndUserName, SndPassword);
            }
            catch (Exception ex)
            {
                log.Error("Fail to get data for IsValidUser - Error:" + ex.Message);
            }
            return _isValid;
        }

        [HttpPost("DownloadBase64DataAsync")]
        public async Task<string> DownloadBase64DataAsync(string fileNameWithPath)
        {
            bool isFTPMODE = _appSettings.FTPConfiguration.FTPMODE;
            var base64 = string.Empty;
            if (isFTPMODE == true)
            {
                int bytesRead;
                // byte[] buffer = new byte[2048];
                byte[] buffer = new byte[1048576]; // 1 MB buffer
                byte[] fileData = null;

                string FTPURL = _appSettings.FTPConfiguration.FtpURL.ToString();
                string FTPUserName = _appSettings.FTPConfiguration.Username.ToString();
                string FTPPassword = _appSettings.FTPConfiguration.Password.ToString();

                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(FTPURL + fileNameWithPath);
                request.Method = WebRequestMethods.Ftp.DownloadFile;
                request.Credentials = new NetworkCredential(FTPUserName, FTPPassword);
                try
                {
                    Stream reader = request.GetResponse().GetResponseStream();
                    using (MemoryStream ms = new MemoryStream())
                    {
                        while (true)
                        {
                            bytesRead = await reader.ReadAsync(buffer, 0, buffer.Length);
                            if (bytesRead == 0)
                                break;
                            ms.Write(buffer, 0, bytesRead);
                        }
                        fileData = ms.ToArray();
                    }
                    reader.Close();
                    base64 = Convert.ToBase64String(fileData);
                }
                catch (WebException ex)
                {
                    FtpWebResponse response = (FtpWebResponse)ex.Response;
                    if (response.StatusCode == FtpStatusCode.ActionNotTakenFileUnavailable)
                    {
                        response.Close();
                    }
                    return null;
                }
            }
            else
            {
                string strDestinationPath = _appSettings
                    .FTPConfiguration.DestinationPath.ToString()
                    .Trim();
                string strFullPath = Path.Combine(strDestinationPath, fileNameWithPath);
                if (string.IsNullOrEmpty(strFullPath) || !System.IO.File.Exists(strFullPath))
                {
                    return "File not found";
                }

                byte[] fileBytes = await System.IO.File.ReadAllBytesAsync(strFullPath);
                base64 = Convert.ToBase64String(fileBytes);
            }
            return base64;
        }

        [HttpGet("GetPDFBase64")]
        public async Task<string> GetPDFBase64(string remoteFilePath)
        {
            // string filePath = @"C:\Users\mohank\Desktop\FTP\9.pdf";
            byte[] fileBytes = System.IO.File.ReadAllBytes(remoteFilePath);
           
           string strbase64=Convert.ToBase64String(fileBytes);
            return strbase64;
        }



        [HttpPost("DownloadBase64LargeFileAsync")]
        public async Task<string> DownloadBase64LargeFileAsync(string remoteFilePath)
        {
            // string filePath = @"C:\Users\mohank\Desktop\FTP\9.pdf";
            // byte[] fileBytes = System.IO.File.ReadAllBytes(filePath);
            // string strbase64=Convert.ToBase64String(fileBytes);
            // return strbase64;

            try
            {
                string _ftpUrl = _appSettings.FTPConfiguration.FtpURL.ToString();
                string _ftpUsername = _appSettings.FTPConfiguration.Username.ToString();
                string _ftpPassword = _appSettings.FTPConfiguration.Password.ToString();

                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(_ftpUrl + remoteFilePath);
                request.Method = WebRequestMethods.Ftp.DownloadFile;
                request.Credentials = new NetworkCredential(_ftpUsername, _ftpPassword);
                request.UseBinary = true;
                request.UsePassive = true;
                request.KeepAlive = true;
                request.Timeout = 2400000; // Increased timeout for large files (40 minutes)
                request.ReadWriteTimeout = 2400000; // Increased read/write timeout for large files

                using (FtpWebResponse response = (FtpWebResponse)await request.GetResponseAsync())
                {
                    using (Stream ftpStream = response.GetResponseStream())
                    {
                        // byte[] buffer = new byte[1024 * 8];
                        byte[] buffer = new byte[1048576]; // 1 MB buffer
                        int bytesRead;
                        using (MemoryStream memoryStream = new MemoryStream())
                        {
                            while (
                                (bytesRead = await ftpStream.ReadAsync(buffer, 0, buffer.Length))
                                > 0
                            )
                            {
                                await memoryStream.WriteAsync(buffer, 0, bytesRead);
                            }
                            byte[] fileData = memoryStream.ToArray();
                            string base64Encoded = Convert.ToBase64String(fileData);
                            return base64Encoded;
                        }
                    }
                }
            }
            catch (WebException ex)
            {
                return ex.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        [HttpPost("RenameFtpFile")]
        public async Task<bool> RenameFtpFile(string source, string destination)
        {
            string FTPURL = _appSettings.FTPConfiguration.FtpURL.ToString();
            string FTPUserName = _appSettings.FTPConfiguration.Username.ToString();
            string FTPPassword = _appSettings.FTPConfiguration.Password.ToString();

            Uri serverFile = new Uri(FTPURL + source);
            FtpWebRequest request = (FtpWebRequest)WebRequest.Create(serverFile);
            request.Method = WebRequestMethods.Ftp.Rename;
            request.UseBinary = true;
            request.Credentials = new NetworkCredential(FTPUserName, FTPPassword);
            request.RenameTo = "/" + destination;
            FtpWebResponse response = (FtpWebResponse)request.GetResponse();
            var success =
                response.StatusCode == FtpStatusCode.CommandOK
                || response.StatusCode == FtpStatusCode.FileActionOK;
            return success;
        }

        [HttpPost("UploadProfileImageAsync")]
        public async Task<string> UploadProfileImageAsync(
            [FromBody] FileResponseModel model,
            string filePath
        )
        {
            if (string.IsNullOrEmpty(filePath) && string.IsNullOrEmpty(model.Base64String))
            {
                return "Should not be empty filePath and file..";
            }
            var imageBytes = ToImageBytes(model.Base64String);
            var imageStream = new MemoryStream(imageBytes);

            bool isFTPMODE = _appSettings.FTPConfiguration.FTPMODE;
            string uploadResponse = string.Empty;
            if (isFTPMODE == true)
            {
                uploadResponse = await this.UploadFileWithStreamAsync(
                    filePath.ToString().Trim(),
                    imageStream
                );
            }
            else
            {
                uploadResponse = await this.UploadFileWithStreamLocal(
                    filePath.ToString().Trim(),
                    imageStream
                );
            }
            return uploadResponse;
        }

        public async Task<string> UploadFileWithStreamLocal(string fileName, Stream stream)
        {
            if (stream == null)
            {
                throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
            }

            if (string.IsNullOrWhiteSpace(fileName))
            {
                throw new ArgumentNullException(
                    nameof(fileName),
                    "File name cannot be null or empty."
                );
            }

            string strDestinationPath = _appSettings
                .FTPConfiguration.DestinationPath.ToString()
                .Trim();
            string strFullPath = Path.Combine(strDestinationPath, fileName);
            string strDirectoryPath = Path.GetDirectoryName(strFullPath);

            // Check if directory exists, if not, create it
            if (!Directory.Exists(strDirectoryPath))
            {
                Directory.CreateDirectory(strDirectoryPath);
            }

            // Check if the file already exists
            if (System.IO.File.Exists(strFullPath))
            {
                return "File already exists.";
            }

            string filePath = Path.Combine(strDirectoryPath, Path.GetFileName(strFullPath));

            try
            {
                // Create and write the file if it doesn't exist
                using (var fileStream = new FileStream(filePath, FileMode.Create, FileAccess.Write))
                {
                    await stream.CopyToAsync(fileStream);
                }
                return string.Empty; // Success
            }
            catch (Exception ex)
            {
                return ex.Message; // Return error message if an exception occurs
            }
        }

        public async Task<string> UploadFileWithStreamAsync(string fileName, Stream stream)
        {
            if (stream == null)
            {
                throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
            }

            if (string.IsNullOrWhiteSpace(fileName))
            {
                throw new ArgumentNullException(
                    nameof(fileName),
                    "File name cannot be null or empty."
                );
            }

            string ftpUrl = _appSettings.FTPConfiguration.FtpURL.ToString();
            string ftpUserName = _appSettings.FTPConfiguration.Username.ToString();
            string ftpPassword = _appSettings.FTPConfiguration.Password.ToString();

            if (!ftpUrl.StartsWith("ftp://", StringComparison.OrdinalIgnoreCase))
            {
                throw new ArgumentException("FTP URL must start with ftp://", nameof(ftpUrl));
            }

            if (!ftpUrl.EndsWith("/"))
            {
                ftpUrl += "/";
            }

            string uploadUrl = ftpUrl + fileName;

            try
            {
                Uri uri = new Uri(uploadUrl);
                string strFolderPath = uri.AbsoluteUri.Substring(
                    0,
                    uri.AbsoluteUri.LastIndexOf('/')
                );
                if (CheckFolderExists(strFolderPath, ftpUserName, ftpPassword) == false)
                    CreateFolder(strFolderPath, ftpUserName, ftpPassword);

                FtpWebRequest ftp = (FtpWebRequest)WebRequest.Create(uploadUrl);
                ftp.Credentials = new NetworkCredential(ftpUserName, ftpPassword);
                ftp.KeepAlive = true;
                ftp.UseBinary = true;
                ftp.UsePassive = true;
                ftp.Method = WebRequestMethods.Ftp.UploadFile;
                ftp.Timeout = 2400000; // Increased timeout for large files (40 minutes)
                ftp.ReadWriteTimeout = 2400000; // Increased read/write timeout for large files

                //Console.WriteLine($"Requesting upload to {uploadUrl} with method {ftp.Method}");
                using (Stream ftpStream = await ftp.GetRequestStreamAsync())
                {
                    // byte[] buffer = new byte[2048];
                    byte[] buffer = new byte[1048576]; // 1 MB buffer

                    int bytesRead;
                    while ((bytesRead = await stream.ReadAsync(buffer, 0, buffer.Length)) > 0)
                    {
                        await ftpStream.WriteAsync(buffer, 0, bytesRead);
                    }
                }

                using (FtpWebResponse response = (FtpWebResponse)await ftp.GetResponseAsync())
                {
                    return "";
                }
            }
            catch (WebException ex)
            {
                if (ex.Response is FtpWebResponse response)
                {
                    response.Close();
                }
                return "Exception: " + ex.Message;
            }
            catch (Exception ex)
            {
                return "Exception: " + ex.Message;
            }
        }

        // public async Task<string> UploadFileWithStreamAsync(string fileName, Stream stream)
        // {
        //     if (stream == null)
        //     {
        //         throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
        //     }
        //     if (string.IsNullOrWhiteSpace(fileName))
        //     {
        //         throw new ArgumentNullException(
        //             nameof(fileName),
        //             "File name cannot be null or empty."
        //         );
        //     }

        //     string ftpUrl = _appSettings.FTPConfiguration.FtpURL.ToString();
        //     string ftpUserName = _appSettings.FTPConfiguration.Username.ToString();
        //     string ftpPassword = _appSettings.FTPConfiguration.Password.ToString();

        //     if (!ftpUrl.StartsWith("ftp://", StringComparison.OrdinalIgnoreCase))
        //     {
        //         throw new ArgumentException("FTP URL must start with ftp://", nameof(ftpUrl));
        //     }

        //     if (!ftpUrl.EndsWith("/"))
        //     {
        //         ftpUrl += "/";
        //     }

        //     string uploadUrl = ftpUrl + fileName;

        //     try
        //     {
        //         Uri uri = new Uri(uploadUrl);
        //         string strFolderPath = uri.AbsoluteUri.Substring(
        //             0,
        //             uri.AbsoluteUri.LastIndexOf('/')
        //         );
        //         if (!CheckFolderExists(strFolderPath, ftpUserName, ftpPassword))
        //         {
        //             CreateFolder(strFolderPath, ftpUserName, ftpPassword);
        //         }

        //         FtpWebRequest ftp = (FtpWebRequest)WebRequest.Create(uploadUrl);
        //         ftp.Credentials = new NetworkCredential(ftpUserName, ftpPassword);
        //         ftp.KeepAlive = true;
        //         ftp.UseBinary = true; // Ensure binary mode for PDFs
        //         ftp.UsePassive = true; // Use passive mode for better firewall compatibility
        //         ftp.Method = WebRequestMethods.Ftp.UploadFile;


        //         // Set high timeout values to ensure file upload completion
        //         ftp.Timeout = 2400000; // Increased timeout for large files (40 minutes)
        //         ftp.ReadWriteTimeout = 2400000; // Increased read/write timeout for large files

        //         // Choose an appropriate buffer size for large files (e.g., 512 KB buffer)
        //         byte[] buffer = new byte[1048576]; // 1 MB buffer
        //         int bytesRead;
        //         long totalBytesUploaded = 0;

        //         using (Stream ftpStream = await ftp.GetRequestStreamAsync())
        //         {
        //             while ((bytesRead = await stream.ReadAsync(buffer, 0, buffer.Length)) > 0)
        //             {
        //                 await ftpStream.WriteAsync(buffer, 0, bytesRead);
        //                 totalBytesUploaded += bytesRead;
        //             }
        //         }

        //         using (FtpWebResponse response = (FtpWebResponse)await ftp.GetResponseAsync())
        //         {
        //             // Console.WriteLine($"FTP Response: {response.StatusCode}");
        //             if (response.StatusCode == FtpStatusCode.ClosingData)
        //             {
        //                 return ""; // Success
        //             }
        //             else
        //             {
        //                 return response.StatusDescription; // Return status description if not successful
        //             }
        //         }
        //     }
        //     catch (WebException ex)
        //     {
        //         if (ex.Response is FtpWebResponse response)
        //         {
        //             using (response)
        //             {
        //                 return "FTP Error: " + response.StatusDescription;
        //             }
        //         }
        //         return "WebException: " + ex.Message;
        //     }
        //     catch (Exception ex)
        //     {
        //         return "Exception: " + ex.Message;
        //     }
        // }

        // public static byte[] ToImageBytes(string image) =>
        //     !string.IsNullOrEmpty(image)
        //         ? Convert.FromBase64String(
        //             Regex.Replace(
        //                 image,
        //                 "data:image/(png|jpg|PNG|JPG|JPEG|jpeg|gif|GIF|bmp|BMP);base64,",
        //                 string.Empty
        //             )
        //         )
        //         : null;

        public static byte[] ToImageBytes(string image)
        {
            if (string.IsNullOrEmpty(image))
                return null;

            try
            {
                // Remove the data:image part (if it exists) using a regex
                string base64String = Regex.Replace(
                    image,
                    @"^data:image\/(png|jpg|jpeg|gif|bmp);base64,",
                    string.Empty,
                    RegexOptions.IgnoreCase
                );

                // Decode the base64 string to bytes
                return Convert.FromBase64String(base64String);
            }
            catch (FormatException ex)
            {
                // Catch any base64 errors
                Console.WriteLine("Invalid base64 string: " + ex.Message);
                return null;
            }
        }

        [HttpPost("DeleteFTPFile")]
        public async Task<int> DeleteFTPFile(string fileNameWithDestinationPath)
        {
            try
            {
                string FTPURL = _appSettings.FTPConfiguration.FtpURL.ToString();
                string FTPUserName = _appSettings.FTPConfiguration.Username.ToString();
                string FTPPassword = _appSettings.FTPConfiguration.Password.ToString();

                FtpWebRequest ftp = (FtpWebRequest)
                    WebRequest.Create(FTPURL + fileNameWithDestinationPath);
                ftp.Credentials = new NetworkCredential(FTPUserName, FTPPassword);
                ftp.KeepAlive = true;
                ftp.UseBinary = true;
                ftp.UsePassive = true;
                ftp.Method = WebRequestMethods.Ftp.DeleteFile;
                FtpWebResponse response = (FtpWebResponse)await ftp.GetResponseAsync();
                var statuscode = (int)response.StatusCode;
                response.Close();
                return statuscode;
            }
            catch (WebException ex)
            {
                FtpWebResponse response = (FtpWebResponse)ex.Response;
                if (response.StatusCode == FtpStatusCode.ActionNotTakenFileUnavailable)
                {
                    response.Close();
                    return 1;
                }
                else
                {
                    response.Close();
                    return 0;
                }
            }
        }

        public bool CheckIfFileExistsOnServer(string fileName)
        {
            string FTPURL = _appSettings.FTPConfiguration.FtpURL.ToString();
            string FTPUserName = _appSettings.FTPConfiguration.Username.ToString();
            string FTPPassword = _appSettings.FTPConfiguration.Password.ToString();

            var request = (FtpWebRequest)WebRequest.Create(FTPURL + fileName);
            request.Credentials = new NetworkCredential(FTPUserName, FTPPassword);
            request.Method = WebRequestMethods.Ftp.GetFileSize;
            request.KeepAlive = true;
            request.UseBinary = true;
            request.UsePassive = true;
            try
            {
                var response = (FtpWebResponse)request.GetResponse();
                response.Close();
                return true;
            }
            catch (WebException ex)
            {
                FtpWebResponse response = (FtpWebResponse)ex.Response;
                if (response.StatusCode == FtpStatusCode.ActionNotTakenFileUnavailable)
                {
                    response.Close();
                    return false;
                }
                response.Close();
            }
            return false;
        }

        public bool CheckFolderExists(string folderName, string username, string password)
        {
            try
            {
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(folderName);
                request.Credentials = new NetworkCredential(username, password);
                request.Method = WebRequestMethods.Ftp.ListDirectory;
                using (FtpWebResponse response = (FtpWebResponse)request.GetResponse())
                {
                    return true;
                }
            }
            catch (WebException ex)
            {
                FtpWebResponse response = (FtpWebResponse)ex.Response;
                if (response.StatusCode == FtpStatusCode.ActionNotTakenFileUnavailable)
                {
                    return false;
                }
                else
                {
                    return false;
                }
            }
        }

        public bool CreateFolder(string folderName, string username, string password)
        {
            try
            {
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(folderName);
                request.Credentials = new NetworkCredential(username, password);
                request.Method = WebRequestMethods.Ftp.MakeDirectory;
                using (FtpWebResponse response = (FtpWebResponse)request.GetResponse())
                {
                    return true;
                }
            }
            catch (WebException ex)
            {
                return false;
            }
        }

        // [HttpPost("UploadProfileImageAsyncLargeFiles")]
        // public async Task<string> UploadProfileImageAsyncLargeFiles(
        //     [FromBody] FileResponseModel model,
        //     string filePath
        // )
        // {
        //     if (string.IsNullOrEmpty(filePath) && string.IsNullOrEmpty(model.Base64String))
        //     {
        //         return "Should not be empty filePath and file..";
        //     }
        //     var imageBytes = ToImageBytes(model.Base64String);
        //     var imageStream = new MemoryStream(imageBytes);
        //     var uploadResponse = await this.UploadFileWithStreamAsync_New(filePath, imageStream);
        //     return uploadResponse;
        // }

        // public async Task<string> UploadFileWithStreamAsync_New(string fileName, Stream stream)
        // {
        //     if (stream == null)
        //     {
        //         throw new ArgumentNullException(nameof(stream), "Stream cannot be null.");
        //     }
        //     if (string.IsNullOrWhiteSpace(fileName))
        //     {
        //         throw new ArgumentNullException(
        //             nameof(fileName),
        //             "File name cannot be null or empty."
        //         );
        //     }

        //     string ftpUrl = _appSettings.FTPConfiguration.FtpURL.ToString();
        //     string ftpUserName = _appSettings.FTPConfiguration.Username.ToString();
        //     string ftpPassword = _appSettings.FTPConfiguration.Password.ToString();

        //     // Ensure the URL starts with "ftp://" and ends with a slash
        //     if (!ftpUrl.StartsWith("ftp://", StringComparison.OrdinalIgnoreCase))
        //     {
        //         throw new ArgumentException("FTP URL must start with ftp://", nameof(ftpUrl));
        //     }

        //     if (!ftpUrl.EndsWith("/"))
        //     {
        //         ftpUrl += "/";
        //     }

        //     string uploadUrl = ftpUrl + fileName;

        //     try
        //     {
        //         // Extract the FTP server host from the FTP URL
        //         Uri uri = new Uri(uploadUrl);
        //         string ftpHost = uri.Host;

        //         // Create an FTP client using FluentFTP
        //         using (
        //             FluentFTP.FtpClient ftpClient = new FluentFTP.FtpClient(
        //                 ftpHost,
        //                 new NetworkCredential(ftpUserName, ftpPassword)
        //             )
        //         )
        //         {
        //             // Connect to the FTP server asynchronously
        //             await ftpClient.ConnectAsync();

        //             // Extract the folder path (directory) from the URL (excluding the protocol part and file name)
        //             string remoteFolderPath = uri.AbsolutePath;

        //             // Normalize the path: replace backslashes with forward slashes
        //             remoteFolderPath = remoteFolderPath.Replace("\\", "/");


        //             // Remove the file name from the path, leaving only the directory portion
        //             remoteFolderPath = Path.GetDirectoryName(remoteFolderPath);

        //             // Ensure the folder path ends with a slash
        //             if (!remoteFolderPath.EndsWith("/"))
        //             {
        //                 remoteFolderPath += "/";
        //             }

        //             // Log the path for debugging
        //             Console.WriteLine($"Checking if directory exists: {remoteFolderPath}");

        //             // Check if the directory exists
        //             bool directoryExists = await ftpClient.DirectoryExistsAsync(remoteFolderPath);

        //             if (directoryExists)
        //             {
        //                 Console.WriteLine("Directory exists.");
        //             }
        //             else
        //             {
        //                 Console.WriteLine("Directory does not exist.");
        //             }

        //             // If the directory does not exist, create it
        //             if (!directoryExists)
        //             {
        //                 await ftpClient.CreateDirectoryAsync(remoteFolderPath);
        //                 Console.WriteLine("Directory created.");
        //             }

        //             // Upload the file to the FTP server
        //             FtpStatus uploadStatus = await ftpClient.UploadAsync(
        //                 stream,
        //                 fileName,
        //                 FtpRemoteExists.Overwrite
        //             );

        //             // Check if the upload was successful
        //             if (uploadStatus == FtpStatus.Success)
        //             {
        //                 return "";
        //             }
        //             else
        //             {
        //                 return "File upload failed. Status: " + uploadStatus.ToString();
        //             }
        //         }
        //     }
        //     catch (FtpException ex)
        //     {
        //         return "FTP Error: " + ex.Message;
        //     }
        //     catch (Exception ex)
        //     {
        //         return "Exception: " + ex.Message;
        //     }
        // }
    }
}
