﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The inventory product.
    /// </summary>
    public class InventoryProduct
    {
        /// <summary>
        /// Gets or sets the inventory product id.
        /// </summary>
        [Key, Identity]
        public int InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the company id.
        /// </summary>
        public int CompanyId { get; set; }

        /// <summary>
        /// Gets or sets the category id.
        /// </summary>
        public int CategoryId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit.
        /// </summary>
        public int PurchaseUnit { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit quantity.
        /// </summary>
        public int PurchaseUnitQuantity { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is batch number.
        /// </summary>
        public bool IsBatchNumber { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is expiry.
        /// </summary>
        public bool IsExpiry { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
