﻿using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.EntityModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Infrastructure.Services
{
    public class AmbulanceService:IAmbulanceService
    {
        private readonly IUnitOfWork unitOfWork;


        public AmbulanceService(IUnitOfWork unitOfWorks)
        {
            this.unitOfWork = unitOfWorks;
        }

        public async Task<int>AddAsync(AmbulanceModel model)
        {
            
            var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""AmbulanceId"") FROM ""Ambulance"" WHERE ""AmbulanceNo"" = '{model.AmbulanceNo}'");
            if (checkIf>0)
            {
                return -1;
            }
            var ambulance = new Ambulance
            {
                AmbulanceId = model.AmbulanceId,
                AmbulanceNo = model.AmbulanceNo,
                AssignedNo = model.AssignedNo,
                Active = true,
                CreatedBy = model.CreatedBy,
                CreatedDate = DateTime.Now,
                LocationId=model.LocationId
            };
            return await this.unitOfWork.Ambulance.InsertAsync(ambulance);           
             
        }

        public Task<IEnumerable<AmbulanceModel>> FetchAsync(AmbulanceModel model)
        {
            var where = $@" 1=1 ";
            if (model.LocationId != null)
            {
                where += $@" and L.""LocationId""={model.LocationId} ";
            }
            //var query = $@"Select * from ""ReferralDoctor"" where  {where} order by ""CreatedDate"" desc";
            var query = $@"select AB.* , L.""Name"" as ""LocationName"",A.""FullName"" as ""CreatedByName"",B.""FullName"" as ""ModifiedByName""  from ""Ambulance"" AB 
                        join ""Account"" A on A.""AccountId""=AB.""CreatedBy"" 
                        left join ""Account"" B on B.""AccountId""=AB.""ModifiedBy""
                        join ""Location"" L on L.""LocationId""=AB.""LocationId"" where {where} order by ""CreatedDate"" desc";

            return this.unitOfWork.Current.QueryAsync<AmbulanceModel>(query);
        }

        public async Task<int> UpdateAsync(AmbulanceModel model)
        {            
            var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(*) FROM ""Ambulance"" WHERE (""AmbulanceNo"") = '{model.AmbulanceNo}' and ""AmbulanceId""<>{model.AmbulanceId} ");
            if (checkIf > 0)
            {
                return -1;
            }

            var ambulance = await this.unitOfWork.Ambulance.FindAsync(m => m.AmbulanceId == model.AmbulanceId);            
            ambulance.AmbulanceNo = model.AmbulanceNo;
            ambulance.AssignedNo = model.AssignedNo;
            ambulance.Active = true;
            ambulance.ModifiedBy = model.CreatedBy;
            ambulance.ModifiedDate = DateTime.Now;          
            
            return await this.unitOfWork.Ambulance.UpdateAsync(ambulance);
        }

        public Task<int> ModifyStatusAsync(int ambulancerId, int modifiedBy, bool status)
        {
            var query = $@"UPDATE ""Ambulance"" SET ""Active"" = {!status}, ""ModifiedBy"" = {modifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""AmbulanceId""= {ambulancerId}";
            return this.unitOfWork.Current.ExecuteAsync(query);
        }

        /// <inheritdoc />
        //public Task<int> DeleteAsync(int ambulanceId)
        //{
        //    var query = $@"DELETE FROM ""Ambulance"" WHERE ""AmbulanceId""= {ambulanceId}";
        //    return this.unitOfWork.Current.ExecuteAsync(query);
        //}
        public async Task<string> FindNameByAmbulanceId(int ambulanceId)
        {
            var query = $@"SELECT ""AmbulanceNo"" FROM ""Ambulance""  WHERE ""AmbulanceId"" = {ambulanceId} ";
            var response = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<string>(query);
            return response;
        }
    }
}
