﻿import { MenuType } from "../enums";

export interface IMenuModel {
    id: number;
    mainPage: string;
    subPage: string;
    category: string;
    url: string;
    count: number;
    priority: number;
    generalClasses: string;
    iconClasses: string;
    menuTypeId: MenuType;
    encounterKey: string;
    isEncounterCompleted: boolean;
    encounterCompletedCount: number;

    displayName: string;
    activeRoute: string;

    hasMarker?: boolean;
    isHovering?: boolean;

    categoryMenus: Array<ICategoryMenuModel>;
}

export interface ICategoryMenuModel {
    id: number;
    priority: number;
    url: string;
    subPage: string;
    displayName: string;
    iconClasses: string;
    isEncounterCompleted: boolean;
}

export interface IMenuOverAllModel {
    isFullAccess: boolean;
    menus: Array<IMenuModel>;
    menuButtonCodes: Array<string>;
}







