﻿namespace Hims.Shared.EntityModels
{
   
    using System;
    using System.ComponentModel.DataAnnotations;
    using Hims.Shared.Dapper.Attributes;
    /// <summary>
    /// The coupon.
    /// </summary>
    public class EncounterTypeModel
    {
        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        [Key, Identity]
        public int EncounterTypeId { get; set; }

        /// <summary>
        /// Gets or sets the charge name.
        /// </summary>
        public string EncounterName { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or Sets the modified By Name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the  Location Id.
        /// </summary>
        public int? LocationId { get; set; }

    }
}
