﻿namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The patient document filter model.
    /// </summary>
    public class PatientDocumentFilterModel
    {
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the patient document id.
        /// </summary>
        public int? PatientDocumentId { get; set; }
    }

    /// <summary>
    /// The patient document filter model.
    /// </summary>
    public class PatientDocumentViewModel { 
    
        /// <summary>
        /// gets or sets the base64.
        /// </summary>
        public string? Base64 { get; set; }

        /// <summary>
        /// gets or sets the DocumentUrl.
        /// </summary>
        public string? DocumentUrl { get; set; }

        /// <summary>
        /// gets or sets the FTP ErrorMessage.
        /// </summary>
        public string? ErrorMessage { get; set; }
        
    }
}