﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The inventory purchase bill model.
    /// </summary>
    public class IndentInventoryModel
    {
        /// <summary>
        /// Gets or sets the indent header id.
        /// </summary>
        public int? IndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the department name.
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the reason for requirement.
        /// </summary>
        public string ReasonForRequirement { get; set; }

        /// <summary>
        /// Gets or sets the indent to.
        /// </summary>
        public string IndentTo { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the approved by name.
        /// </summary>
        public string ApprovedByName { get; set; }

        /// <summary>
        /// Gets or sets the required date.
        /// </summary>
        public DateTime? RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets the approved by.
        /// </summary>
        public int? ApprovedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the indent detail id.
        /// </summary>
        public int? IndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the product id.
        /// </summary>
        public int? ProductId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int? Quantity { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the issue quantity.
        /// </summary>
        public string IssuedQuantity { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string ToDate { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the approved date.
        /// </summary>
        public DateTime? ApprovedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the retail name.
        /// </summary>
        public string RetailName { get; set; }

        /// <summary>
        /// Gets or sets the approved by name person's -Role .
        /// </summary>
        public string ApprovedByRoleName { get; set; }

        /// <summary>
        /// Gets or sets the created by name person's -Role .
        /// </summary>
        public string CreatedByRoleName { get; set; }
    }
}
