﻿namespace Hims.Shared.UserModels.Laboratory
{
    /// <summary>
    /// The lab report param model.
    /// </summary>
    public class LabReportParamModel
    {
        /// <summary>
        /// Gets or sets the lab detail id.
        /// </summary>
        public int LabDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab header id.
        /// </summary>
        public int LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the refrence range unit.
        /// </summary>
        public int RefrenceRangeUnit { get; set; }

        /// <summary>
        /// Gets or sets the test parameter.
        /// </summary>
        public string TestParameter { get; set; }

        /// <summary>
        /// Gets or sets the reference range.
        /// </summary>
        public string ReferenceRange { get; set; }

        /// <summary>
        /// Gets or sets the refrence range unit name.
        /// </summary>
        public string RefrenceRangeUnitName { get; set; }

        /// <summary>
        /// Gets or sets the test param result.
        /// </summary>
        public string TestParamResult { get; set; }

        /// <summary>
        /// Gets or sets the typed by name.
        /// </summary>
        public string TypedByName { get; set; }

        /// <summary>
        /// Gets or sets the lab patient parameter id.
        /// </summary>
        public int LabPatientParameterId { get; set; }

        /// <summary>
        /// Gets or sets the typed by.
        /// </summary>
        public int? TypedBy { get; set; }

        /// <summary>
        /// Gets or sets the verified by.
        /// </summary>
        public int? VerifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the verified by name.
        /// </summary>
        public string VerifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the verified by doctor.
        /// </summary>
        /// <value>
        /// The name of the verified by doctor.
        /// </value>
        public string VerifiedByDoctorName { get; set; }

        /// <summary>
        /// Gets or sets the typed date.
        /// </summary>
        public System.DateTime? TypedDate { get; set; }

        /// <summary>
        /// Gets or sets the lab booking package detail id.
        /// </summary>
        public int? LabBookingPackageDetailId { get; set; }
    }
}
