﻿using System;
using System.ComponentModel.DataAnnotations;

namespace Hims.Shared.UserModels.NurseShift
{
    /// <summary>
    /// The basic bed Nurse Shift Map.
    /// </summary>
    public class BedFilterModel
    {
        /// <summary>
        /// Gets or sets the nurse shift map identifier.
        /// </summary>
        /// <value>
        /// The nurse shift map identifier.
        /// </value>
        public int? NurseShiftMapId { get; set; }

        /// <summary>
        /// Gets or sets the is retouch.
        /// </summary>
        /// <value>
        /// The is retouch.
        /// </value>
        public bool? IsRetouch { get; set; }

        /// <summary>
        /// Gets or sets from date.
        /// </summary>
        /// <value>
        /// From date.
        /// </value>
        public DateModel FromDate { get; set; }

        /// <summary>
        /// Converts to date.
        /// </summary>
        /// <value>
        /// To date.
        /// </value>
        public DateModel ToDate { get; set; }

        /// <summary>
        /// Gets or sets the shift identifier.
        /// </summary>
        /// <value>
        /// The shift identifier.
        /// </value>
        [Required]
        public int ShiftId { get; set; }

        public int? NurseAccountId { get; set; }
    }
}