﻿namespace Hims.Shared.UserModels.OperationTheater
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    
        /// <summary>
        /// The book OT appointment.
        /// </summary>
        public class OTFilterModel
        {


            /// <summary>
            /// Gets or sets the book scan appointment id.
            /// </summary>
            public string OTRoomIds { get; set; }

            /// <summary>
            /// Gets or sets the book scan appointment id.
            /// </summary>
            public string OTRoomId { get; set; }

            /// <summary>
            /// Gets or sets the scan test master id.
            /// </summary>
            public string SurgeryId { get; set; }

            /// <summary>
            /// Gets or sets the slot duration.
            /// </summary>
            public int? SlotDuration { get; set; }

            /// <summary>
            /// Gets or sets the slot duration.
            /// </summary>
            public int LocationId { get; set; }


            /// <summary>
            /// Gets or sets the start date.
            /// </summary>
            public string? AppointmentDate { get; set; }

            /// <summary>
            /// Gets or sets the end date.
            /// </summary>
            public string? AppointmentEndDate { get; set; }

            /// <summary>
            /// Gets or sets the calendar view
            /// </summary>
            public string? CalendarView { get; set; }

            /// <summary>
            /// Gets or sets the appointment status.
            /// </summary>
            public bool AppointmentStatus { get; set; }

            /// <summary>
            /// Gets or sets the products.
            /// </summary>
            public List<AppFilterModel> Filter { get; set; }

        }

        /// <summary>
        /// The App filter model.
        /// </summary>
        public class AppFilterModel
        {
            /// <summary>
            /// Gets or sets the patient id.
            /// </summary>
            public int? PatientId { get; set; }

            /// <summary>
            /// Gets or sets the patient name.
            /// </summary>
            public string PatientName { get; set; }

            /// <summary>
            /// Gets or sets the from date.
            /// </summary>
            public string FromDate { get; set; }

        }
    }

