﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.ProgressReport.Labs
{
    using static Timeline.Enums;
    public class NewLabsViewModel
    {
        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Creates new labbookingheaderid.
        /// </summary>
        /// <value>
        /// The new lab booking header identifier.
        /// </value>
        public int NewLabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the name of the test.
        /// </summary>
        /// <value>
        /// The name of the test.
        /// </value>
        public string TestName { get; set; }

        /// <summary>
        /// Gets or sets the test code.
        /// </summary>
        /// <value>
        /// The test code.
        /// </value>
        public string TestCode { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double? Cost { get; set; }

        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        /// <value>
        /// The date.
        /// </value>
        public DateTime Date { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        /// <value>
        /// The salutation.
        /// </value>
        public string Salutation { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        /// <value>
        /// The age.
        /// </value>
        public int Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the patient image.
        /// </summary>
        /// <value>
        /// The patient image.
        /// </value>
        public string PatientImage { get; set; }

        /// <summary>
        /// Gets or sets the notes.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string Notes { get; set; }

        /// <summary>
        /// Gets or sets the when.
        /// </summary>
        /// <value>
        /// The when.
        /// </value>
        public WhenType? When { get; set; }
    }
}
