﻿namespace Hims.Shared.UserModels.Slots
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The Doctor slots
    /// </summary>
    public class DoctorScheduleSlotModel
    {
        

        /// <summary>
        /// Gets or sets the slot name.
        /// </summary>
        public string SlotName { get; set; }

        /// <summary>
        /// Gets or sets the slot time.
        /// </summary>
        public TimeSpan SlotTime { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public SlotStatus Status { get; set; }

        /// <summary>
        /// Gets or sets the slot value.
        /// </summary>
        public string SlotName12HoursEnd { get; set; }

        
        /// <summary>
        /// Gets or sets the slot type.
        /// </summary>
        public SlotType SlotType { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public string AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string? UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string ANCCardGeneration { get; set; }
        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }
        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }
        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the scan test name.
        /// </summary>
        public string ScanTestName { get; set; }
        /// <summary>
        /// Gets or sets the slot end time.
        /// </summary>
        public string EndTime { get; set; }

        /// <summary>
        /// Gets or sets the booked end time.
        /// </summary>
        public string AppointmentEndTime { get; set; }
        




    }

}