﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The patient lab detail.
    /// </summary>
    public class PatientLabDetail
    {
        /// <summary>
        /// Gets or sets the patient lab detail identifier.
        /// </summary>
        /// <value>
        /// The patient lab detail identifier.
        /// </value>
        [Key, Identity]
        public int PatientLabDetailId { get; set; }

        /// <summary>
        /// Gets or sets the patient lab header identifier.
        /// </summary>
        /// <value>
        /// The patient lab header identifier.
        /// </value>
        public int PatientLabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int LabMainDetailId { get; set; }
    }
}
