﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The web telemedicine.
    /// </summary>
    public class TelemedicineUsersHistory
    {
        /// <summary>
        /// Gets or sets the web telemedicine id.
        /// </summary>
        [Key, Identity]
        public int TelemedicineUsersHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the web telemedicine id.
        /// </summary>
        public int TelemedicineCallHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int CallerId { get; set; }

        /// <summary>
        /// Gets or sets the count.
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        public DateTime? Date { get; set; }

        /// <summary>
        /// Gets or sets the in progress.
        /// </summary>
        /// <value>
        /// The in progress.
        /// </value>
        public bool? InProgress { get; set; }
    }
}