﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The patient family.
    /// </summary>
    public class PatientFamily
    {
        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        [Key, Identity]
        public int PatientFamilyId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the relation.
        /// </summary>
        public string Relation { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public int Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime ModifiedDate { get; set; }     
             /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? DOB { get; set; }
        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public string Occupation { get; set; }

        /// <summary>
        /// Gets or sets the occupation details.
        /// </summary>
        /// <value>
        /// The occupation details.
        /// </value>
        public string OccupationDetails { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public string Education { get; set; }
        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public string ContactNo { get; set; }

        /// <summary>
        /// Gets or sets the Blood group
        /// </summary>
        public string BloodGroup { get; set; }

    }
}
