﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The provider leave.
    /// </summary>
    public class ProviderLeave
    {
        /// <summary>
        /// Gets or sets the provider leave id.
        /// </summary>
        [Key, Identity]
        public long ProviderLeaveId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        [IgnoreUpdate]
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the leave date.
        /// </summary>
        public DateTime LeaveDate { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int? ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string Reason { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int? ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider leave end time.
        /// </summary>
        public TimeSpan? ProviderLeaveEndTime { get; set; }

        /// <summary>
        /// Gets or sets the provider leave start time.
        /// </summary>
        public TimeSpan? ProviderLeaveStartTime { get; set; }

    }
}
