﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The surgery.
    /// </summary>
    public class Surgery
    {
        /// <summary>
        /// Gets or sets the surgery identifier.
        /// </summary>
        /// <value>
        /// The surgery identifier.
        /// </value>
        [Key, Identity]
        public int SurgeryId { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="Surgery"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the expected amount.
        /// </summary>
        /// <value>
        /// The expected amount.
        /// </value>
        public double ExpectedAmount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int Duration { get; set; }
        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the module master identifier.
        /// </summary>
        /// <value>
        /// The module master identifier.
        /// </value>
        [IgnoreUpdate]
        public int ModulesMasterId { get; set; }
    }
}
