﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Threading.Tasks;
    using System.Collections.Generic;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Shared.EntityModels;
    using Dapper;
    using Hims.Shared.UserModels.UserExcel;

    /// <inheritdoc />
    public class UserExcelHistoryService : IUserExcelHistoryService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IExcelUploadHistoryService" />
        public UserExcelHistoryService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc />
        public async Task<IEnumerable<ExcelUploadHistoryModel>> FetchAllAsync(ExcelUploadHistoryModel model)
        {
            var where = "where 1=1 ";

            if (!string.IsNullOrEmpty(model.TypeOf))
            {
                where += $@" and EUH.""TypeOf"" ='{model.TypeOf}'";
            }

            var query = $@" Select count(EUH.*) over() as ""TotalItems"",EUH.*, A.""FullName"" as ""UploadedByName"", l.""Name"" as ""LocationName"" from ""ExcelUploadHistory"" EUH 
                            join ""Account"" A on A.""AccountId"" = EUH.""UploadedBy""
                            left join ""Location"" l on l.""LocationId"" = EUH.""LocationId""
                            {where}
                            order by ""CreatedDate"" desc";

            if (model.PageIndex != null && model.PageSize != null)
            {
                model.PageIndex = model.PageIndex > 0 ? model.PageIndex - 1 : model.PageIndex;
                query += $@" limit {model.PageSize} offset {model.PageSize * model.PageIndex}";
            }

            return await this.unitOfWork.Current.QueryAsync<ExcelUploadHistoryModel>(query);
        }

        /// <inheritdoc />
        public async Task<UserExcelHistoryModel> GetSingleExcelHistory(int userExcelHistoryId)
        {
            var data = await this.unitOfWork.UserExcelHistory.FindAsync(m => m.UserExcelHistoryId == userExcelHistoryId);
            return new UserExcelHistoryModel
            {

                CreatedDate = data.CreatedDate,
                UserExcelHistoryId = data.UserExcelHistoryId,

                SheetName = data.SheetName,
                //SheetType = data.SheetType,

                UploadedBy = data.UploadedBy
            };
        }

        public async Task<int> ModifyExcelUploadAsync(UserExcelHistoryModel model)
        {
            var upload = new UserExcelHistory
            {
                CreatedDate = DateTime.UtcNow.AddMinutes(330),
                SheetName = model.SheetName,
                UploadedBy = model.UploadedBy,
                LocationId = model.LocationId,
                AddedUsers = model.AddedUsers,
            };
            if(model.UserExcelHistoryId == 0)
            {
                return await this.unitOfWork.UserExcelHistory.InsertAsync(upload);
            }
            else
            {
                var previousRecord = await this.unitOfWork.UserExcelHistory.FindAsync(m => m.UserExcelHistoryId == model.UserExcelHistoryId);
                var completeUserList = previousRecord.AddedUsers + "," + upload.AddedUsers;
                previousRecord.AddedUsers = completeUserList;
                await this.unitOfWork.UserExcelHistory.UpdateAsync(previousRecord);
                return previousRecord.UserExcelHistoryId;
            }
        }

        public async Task<IEnumerable<UserExcelHistoryModel>> FetchAllAsync(UserExcelHistoryModel model)
        {
            var where = "where 1=1 ";

            var query = $@" Select count(UEH.*) over() as ""TotalItems"",UEH.*, A.""FullName"" as ""UploadedByName"", l.""Name"" as ""LocationName"" from ""UserExcelHistory"" UEH 
                            join ""Account"" A on A.""AccountId"" = UEH.""UploadedBy""
                            left join ""Location"" l on l.""LocationId"" = UEH.""LocationId""
                            {where}
                            order by ""CreatedDate"" desc";

            if (model.PageIndex != null && model.PageSize != null)
            {
                model.PageIndex = model.PageIndex > 0 ? model.PageIndex - 1 : model.PageIndex;
                query += $@" limit {model.PageSize} offset {model.PageSize * model.PageIndex}";
            }

            return await this.unitOfWork.Current.QueryAsync<UserExcelHistoryModel>(query);
        }
    }
}