﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The internal medicine model.
    /// </summary>
    public class InternalMedicineModel
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int? EncounterId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the problem list.
        /// </summary>
        public string? ProblemList { get; set; }

        /// <summary>
        /// Gets or sets the cheif complaints.
        /// </summary>
        public string? CheifComplaints { get; set; }

        /// <summary>
        /// Gets or sets the follow up.
        /// </summary>
        public string? FollowUp { get; set; }

        /// <summary>
        /// Gets or sets the medications.
        /// </summary>
        public string? Medications { get; set; }

        /// <summary>
        /// Gets or sets the notes.
        /// </summary>
        public string? Notes { get; set; }

        /// <summary>
        /// Gets or sets the vitals.
        /// </summary>
        public string? Vitals { get; set; }

        /// <summary>
        /// Gets or sets the family medical history.
        /// </summary>
        public string? FamilyMedicalHistory { get; set; }

        /// <summary>
        /// Gets or sets the social history.
        /// </summary>
        public string? SocialHistory { get; set; }

        /// <summary>
        /// Gets or sets the diagnosis.
        /// </summary>
        public string? Diagnosis { get; set; }

        /// <summary>
        /// Gets or sets the general advice.
        /// </summary>
        public string? GeneralAdvice { get; set; }

        /// <summary>
        /// Gets or sets the symptoms.
        /// </summary>
        public string? Symptoms { get; set; }

        /// <summary>
        /// Gets or sets the heent.
        /// </summary>
        public string? Heent { get; set; }

        /// <summary>
        /// Gets or sets the extremities.
        /// </summary>
        public string? Extermities { get; set; }

        /// <summary>
        /// Gets or sets the respiratory.
        /// </summary>
        public string? Respiratory { get; set; }

        /// <summary>
        /// Gets or sets the skin.
        /// </summary>
        public string? Skin { get; set; }

        /// <summary>
        /// Gets or sets the abdomen.
        /// </summary>
        public string? Abdomen { get; set; }

        /// <summary>
        /// Gets or sets the ekg.
        /// </summary>
        public string? Ekg { get; set; }

        /// <summary>
        /// Gets or sets the musculoskeletal.
        /// </summary>
        public string? Musculoskeletal { get; set; }

        /// <summary>
        /// Gets or sets the neurology.
        /// </summary>
        public string? Neurology { get; set; }

        /// <summary>
        /// Gets or sets the cardiovascular.
        /// </summary>
        public string? Cardiovascular { get; set; }

        /// <summary>
        /// Gets or sets the allergies.
        /// </summary>
        public string? Allergies { get; set; }

        /// <summary>
        /// Gets or sets the preventive care.
        /// </summary>
        public string? PreventiveCare { get; set; }

        /// <summary>
        /// Gets or sets the immunizations.
        /// </summary>
        public string? Immunization { get; set; }

        /// <summary>
        /// Gets or sets the hospitalization surgery.
        /// </summary>
        public string? HospitalizationSurgery { get; set; }

        /// <summary>
        /// Gets or sets the pastand current medications.
        /// </summary>
        public string? PastandCurrentMedications { get; set; }

        /// <summary>
        /// Gets or sets the current medications.
        /// </summary>
        public string? CurrentMedications { get; set; }

        /// <summary>
        /// Gets or sets the ros.
        /// </summary>
        public string? Ros { get; set; }

        /// <summary>
        /// Gets or sets the medication comment.
        /// </summary>
        public string? MedicationComment { get; set; }
    }
}
