﻿namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The message model.
    /// </summary>
    public class MessageModel
    {
        /// <summary>
        /// Gets or sets the message id.
        /// </summary>
        public long MessageId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the messages.
        /// </summary>
        public string Messages { get; set; }

        /// <summary>
        /// Gets or sets the doctor message count.
        /// </summary>
        public int? DoctorMessageCount { get; set; }

        /// <summary>
        /// Gets or sets the patient message count.
        /// </summary>
        public int? PatientMessageCount { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the request from.
        /// </summary>
        public string RequestFrom { get; set; }
    }
}
