﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The pharmacy issued stock header model.
    /// </summary>
    public class PharmacyIssuedStockHeaderModel
    {
        /// <summary>
        /// Gets or sets the pharmacy issued stock header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy issued stock header identifier.
        /// </value>
        public long? PharmacyIssuedStockHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the issued date.
        /// </summary>
        /// <value>
        /// The issued date.
        /// </value>
        public DateTime IssuedDate { get; set; }

        /// <summary>
        /// Gets or sets the issued by.
        /// </summary>
        /// <value>
        /// The issued by.
        /// </value>
        public int IssuedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the issued by.
        /// </summary>
        /// <value>
        /// The name of the issued by.
        /// </value>
        public string IssuedByName { get; set; }

        /// <summary>
        /// Gets or sets the issue header identifier.
        /// </summary>
        /// <value>
        /// The issue header identifier.
        /// </value>
        public int? IssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the hand over to.
        /// </summary>
        /// <value>
        /// The hand over to.
        /// </value>
        public int? HandOverTo { get; set; }

        /// <summary>
        /// Gets or sets the retail ware house link identifier.
        /// </summary>
        /// <value>
        /// The retail ware house link identifier.
        /// </value>
        public int? RetailWareHouseLinkId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy department identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department identifier.
        /// </value>
        public int? PharmacyDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the received by.
        /// </summary>
        /// <value>
        /// The received by.
        /// </value>
        public int? ReceivedBy { get; set; }

        /// <summary>
        /// Gets or sets the received date.
        /// </summary>
        /// <value>
        /// The received date.
        /// </value>
        public DateTime? ReceivedDate { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the issue number.
        /// </summary>
        /// <value>
        /// The issue number.
        /// </value>
        public string IssueNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the indent raised by.
        /// </summary>
        /// <value>
        /// The name of the indent raised by.
        /// </value>
        public string IndentRaisedByName { get; set; }

        /// <summary>
        /// Gets or sets the indent created date.
        /// </summary>
        /// <value>
        /// The indent created date.
        /// </value>
        public DateTime IndentCreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the hand over.
        /// </summary>
        /// <value>
        /// The name of the hand over.
        /// </value>
        public string HandOverName { get; set; }

        /// <summary>
        /// Gets or sets the raised from location.
        /// </summary>
        /// <value>
        /// The raised from location.
        /// </value>
        public string RaisedFromLocation { get; set; }

        /// <summary>
        /// Gets or sets the raised for retail.
        /// </summary>
        /// <value>
        /// The raised for retail.
        /// </value>
        public string RaisedForRetail { get; set; }

        /// <summary>
        /// Gets or sets the approved from ware house.
        /// </summary>
        /// <value>
        /// The approved from ware house.
        /// </value>
        public string ApprovedFromWareHouse { get; set; }

        /// <summary>
        /// Gets or sets the reason for requirement.
        /// </summary>
        /// <value>
        /// The reason for requirement.
        /// </value>
        public string ReasonForRequirement { get; set; }

        /// <summary>
        /// Gets or sets the raised for department.
        /// </summary>
        /// <value>
        /// The raised for department.
        /// </value>
        public string RaisedForDepartment { get; set; }

        /// <summary>
        /// Gets or sets the name of the received by.
        /// </summary>
        /// <value>
        /// The name of the received by.
        /// </value>
        public string ReceivedByName { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<PharmacyIssuedStockDetailModel> Products { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }
    }

    /// <summary>
    /// The pharmacy issued stock detail model.
    /// </summary>
    public class PharmacyIssuedStockDetailModel
    {
        /// <summary>
        /// Gets or sets the pharmacy issued stock detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy issued stock detail identifier.
        /// </value>
        public long PharmacyIssuedStockDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy issued stock header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy issued stock header identifier.
        /// </value>
        public long PharmacyIssuedStockHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        /// <value>
        /// The batch number.
        /// </value>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock identifier.
        /// </summary>
        /// <value>
        /// The pharmacy stock identifier.
        /// </value>
        public int PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the category.
        /// </summary>
        /// <value>
        /// The category.
        /// </value>
        public string Category { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        /// <value>
        /// The tax percentage.
        /// </value>
        public string TaxPercentage { get; set; }
    }
}
