﻿using Hims.Shared.UserModels.NurseShift;
using System;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.ProgressReport.Medication
{
    /// <summary>
    /// The receipt model
    /// </summary>
    public class FilterModel
    {
        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the admission ids.
        /// </summary>
        /// <value>
        /// The admission ids.
        /// </value>
        public List<int> AdmissionIds { get; set; }

        /// <summary>
        /// Gets or sets the identifier.
        /// </summary>
        /// <value>
        /// The identifier.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        /// <value>
        /// The value.
        /// </value>
        public int? Value { get; set; }

        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        /// <value>
        /// The date.
        /// </value>
        public DateTime Date { get; set; }

        /// <summary>
        /// Gets or sets the date model.
        /// </summary>
        /// <value>
        /// The date model.
        /// </value>
        public DateModel DateModel { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        /// <value>
        /// The end date.
        /// </value>
        public DateTime? EndDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is nurse.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is nurse; otherwise, <c>false</c>.
        /// </value>
        public bool IsNurse { get; set; }
    }
}
