﻿using System;


namespace Hims.Shared.UserModels.Scan.ScanAppointment
{
    /// <summary>
    /// The book scan appointment.
    /// </summary>
    public class FetchBookScanAppointment
    {
        /// <summary>
        /// Gets or sets the book scan appointment id.
        /// </summary>
        public int BookScanAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the book scan appointment id.
        /// </summary>
        public string ScanMachineMasterId { get; set; }

        /// <summary>
        /// Gets or sets the book scan appointment id.
        /// </summary>
        public int ScanMachineMasterIds { get; set; }

        /// <summary>
        /// Gets or sets the charge Category id.
        /// </summary>
        public int chargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the calendar view
        /// </summary>
        public string? EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the book scan test master id.
        /// </summary>
        public string ScanTestMasterId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the payment status.
        /// </summary>
        public bool? PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the PndtReport status.
        /// </summary>
        public bool PndtReport { get; set; }

        /// <summary>
        /// Gets or sets the ScanScrollResult.
        /// </summary>
        public string ScanScrollResult { get; set; }

        /// <summary>
        /// Gets or sets the patient payment status.
        /// </summary>
        public bool PatientPaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the is new patient.
        /// </summary>
        public bool? IsNewPatient { get; set; }

        /// <summary>
        /// Gets or sets the pay type id.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the scan test name.
        /// </summary>
        public string ScanTestName { get; set; }

        /// <summary>
        /// Gets or sets the machine name.
        /// </summary>
        public string MachineName { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the appointment date time.
        /// </summary>
        public string AppointmentStartDateTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment  time.
        /// </summary>
        public string AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNO { get; set; }

        /// <summary>
        /// Gets or sets the appointment  time.
        /// </summary>
        public string AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment  time.
        /// </summary>
        public string AppointmentEndTime { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the FatherOrHusband name.
        /// </summary>
        public string FatherOrHusband { get; set; }

        /// <summary>
        /// Gets or sets the Full Address of patient.
        /// </summary>
        public string FullAddress { get; set; }

        /// <summary>
        /// Gets or sets the slot duration.
        /// </summary>
        public int SlotDuration { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public int Age { get; set; }

        /// <summary>
        /// Gets or sets the appointment date time.
        /// </summary>
        public string AppointmentEndDateTime { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string Reason { get; set; }

        /// <summary>
        /// Gets or sets the pay type name.
        /// </summary>
        public string PayTypeName { get; set; }

        /// <summary>
        /// Gets or sets the from date .
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }
        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the Charge Category Name.
        /// </summary>
        public string ChargeCategoryName { get; set; }

        /// <summary>
        /// Gets or sets the Amount.
        /// </summary>
        public double? Amount { get; set; }

        /// <summary>
        /// Gets or sets the actual paid Amount.
        /// </summary>
        public double? PaidAmount { get; set; }

        /// <summary>
        /// Gets or sets the refund of actual paid Amount.
        /// </summary>
        public double? RefundAmount { get; set; }

        /// <summary>
        /// Gets or sets the today;s paid Amount.
        /// </summary>
        public double? PaidAmt { get; set; }

        /// <summary>
        /// Gets or sets the patient registration Amount.
        /// </summary>
        public double? RegCharges { get; set; }

        /// <summary>
        /// Gets or sets the Scan Amount.
        /// </summary>
        public double? ScanAmount { get; set; }

        /// <summary>
        /// Gets or sets the Scan Net Amount.
        /// </summary>
        public double? NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the Total scan and patient Discount.
        /// </summary>
        public double? TotalDiscount { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the is salucro appointment.
        /// </summary>
        public bool IsSalucroAppointment { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        public string RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public char? TypeOfPayment { get; set; }

        /// <summary>
        /// Gets or sets the Scan Appointment Type.
        /// </summary>
        public string ScanAppointmentType { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double? ActualAmount { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double? Amt { get; set; }

        /// <summary>
        /// Gets or sets the Registration Discount In Rupees.
        /// </summary>
        public double? RegDiscountInRupees { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public bool IsDispatched { get; set; }
        public string Gravida { get; set; }
        public string PeriodOfGestation { get; set; }
        public DateTime? EDD { get; set; }
        public string PaymentType { get; set; }
        public int? ReceiptId { get; set; }
        public int? ScanDocumentId { get; set; }
        public int? HWCPatientId { get; set; }
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the provider Name.
        /// </summary>
        public string ProviderName { get; set; }
        public string BackgroundColor { get; set; }
        public string Indication { get; set; }
        public bool IsPatRegPaid { get; set; }        
        public double PaidScanAmount { get; set; }
    }

    /// <summary>
    /// The book scan appointment response.
    /// </summary>
    public class FetchBookScanAppointmentResponse
    {
        /// <summary>
        /// Gets or sets the response.
        /// </summary>
        public int Response { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }
    } 

    public class FetchPatientFutureAppointment
    {
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the appointment  date.
        /// </summary>
        public string AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment  time.
        /// </summary>
        public string AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the scan test name.
        /// </summary>
        public string ScanTestName { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the scan machine name.
        /// </summary>
        public string MachineName { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }
    }
}