﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The account.
    /// </summary>
    public class Account
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        [Key, Identity]
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the salt key.
        /// </summary>
        [IgnoreUpdate]
        public string SaltKey { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Guid.
        /// </summary>
        [IgnoreUpdate]
        public Guid Guid { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string? Email { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the reference id.
        /// </summary>
        public int ReferenceId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether agreed locked.
        /// </summary>
        public bool? IsAgreed { get; set; }

        /// <summary>
        /// Gets or sets the agreed date.
        /// </summary>
        public DateTime? AgreedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is locked.
        /// </summary>
        public bool IsLocked { get; set; }

        /// <summary>
        /// Gets or sets the failed login attempts.
        /// </summary>
        public short FailedLoginAttempts { get; set; }

        /// <summary>
        /// Gets or sets the last failed login date.
        /// </summary>
        public DateTime? LastFailedLoginDate { get; set; }

        /// <summary>
        /// Gets or sets the last login date.
        /// </summary>
        public DateTime? LastLoginDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets a value otp verified.
        /// </summary>
        public bool? OTPVerified { get; set; }

        /// <summary>
        /// Gets or sets a value manual verified.
        /// </summary>
        public bool? ManualVerified { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the user name.
        /// </summary>
        public string? UserName { get; set; }

        /// <summary>
        /// Gets or sets the finance background.
        /// </summary>
        /// <value>
        /// The finance background.
        /// </value>
        public bool? FinanceBackground { get; set; }

        /// <summary>
        /// Gets or sets the restrict user login.
        /// </summary>
        /// <value>
        /// The restrict user login.
        /// </value>
        public bool? RestrictUserLogin { get; set; }

        /// <summary>
        /// Gets or sets the excel download.
        /// </summary>
        /// <value>
        /// The excel download.
        /// </value>
        public bool? ExcelDownload { get; set; }

        /// <summary>
        /// Gets or sets the caller user.
        /// </summary>
        public string? CallerUser { get; set; }
    }
}