﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class EncounterOrderTemplates
    {
        /// <summary>
        /// Gets or sets the EncounterOrderTemplates identifier.
        /// </summary>
        /// <value>
        /// The EncounterOrderTemplates identifier.
        /// </value>
        [Key, Identity]
        public int EncounterTemplateId { get; set; }

        /// <summary>
        /// Gets or sets the EncounterTypeId.
        /// </summary>
        /// <value>
        /// The EncounterTypeId.
        /// </value>
        public int EncounterTypeId { get; set; }
        /// <summary>
        /// Gets or sets the TemplateName.
        /// </summary>
        /// <value>
        /// The TemplateName.
        /// </value>
        public string TemplateName { get; set; }

        /// <summary>
        /// Gets or sets the Description.
        /// </summary>
        /// <value>
        /// The Description.
        /// </value>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
