﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The pharmacy purchase return header.
    /// </summary>
    public class PharmacyPurchaseReturnHeader
    {
        /// <summary>
        /// Gets or sets the pharmacy purchase return header id.
        /// </summary>
        [Key, Identity]
        public int PharmacyPurchaseReturnHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the return date.
        /// </summary>
        public DateTime ReturnDate { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy purchase header id.
        /// </summary>
        public int PharmacyPurchaseHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the overall bill amount.
        /// </summary>
        public double OverallBillAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall discount.
        /// </summary>
        public double? OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the overall taxes.
        /// </summary>
        public double OverallTaxes { get; set; }

        /// <summary>
        /// Gets or sets the overall net amount.
        /// </summary>
        public double OverallNetamount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
