﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    using Hims.Shared.UserModels.DiscountManagement;

    /// <summary>
    /// The discount management service interface.
    /// </summary>
    public interface IDiscountManagementService
    {

        /// <summary>
        /// The add discount module.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> AddDiscountModule(DiscountModuleModel model);

        /// <summary>
        /// The update discount module.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> UpdateDiscountModule(DiscountModuleModel model);

        /// <summary>
        /// The fetch all discount modules async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<DiscountModuleModel>> FetchAllDiscountModulesAsync(DiscountModuleModel model);

        /// <summary>
        /// The modify discounts per module async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> AddDiscountsPerModuleAsync(DiscountsPerModuleModel model);

        /// <summary>
        /// The update discounts per module async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> UpdateDiscountsPerModuleAsync(DiscountsPerModuleModel model);

        /// <summary>
        /// The get module detail async.
        /// </summary>
        /// <param name="moduleName">
        /// The module name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<DiscountModuleModel> GetModuleDetailsAsync(string moduleName);

        /// <summary>
        /// The get role based discount on module.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<DiscountsPerModuleModel> GetRoleBasedDisocuntOnModule(DiscountsPerModuleModel model);

        /// <summary>
        /// Activates the or deactivate role.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivate(DiscountModuleModel model);

    }
}
