﻿using Hims.Domain.Entities;
using Hims.Shared.UserModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{ /// <summary>
  /// The doctor unit Service interface.
  /// </summary>
    public interface IDoctorUnitService
    {


        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(DoctorUnitMasterModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<DoctorUnitMasterModel>> FetchAllAsync(DoctorUnitMasterModel model);
        /// <summary>
        /// Activates the or deactivate doctor unit.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateTest(DoctorUnitMasterModel model);
        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(DoctorUnitMasterModel model);
    }
}
