﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    /// <summary> The ChatService interface.</summary>
    public interface IIconService
    {
        /// <summary>
        /// The add icons.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddIcons(IconsModel model);

        /// <summary>
        /// The fetch icons.
        /// </summary>
        /// <param name="pageSize">
        /// The page size.
        /// </param>
        /// <param name="pageIndex">
        /// The page index.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<IconsModel>> FetchIcons(int pageSize, int pageIndex);

        /// <summary>
        /// The delete icons async.
        /// </summary>
        /// <param name="iconId">
        /// The icon id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteIconsAsync(int iconId);
    }
}
