﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    using Hims.Shared.UserModels.Filters;

    /// <summary>
    /// The ILabOrderValue Service interface.
    /// </summary>
    public interface ILabOrderValueService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<LabOrderValueModel>> FetchAsync(LabOrderValueFilterModel model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(LabOrderValueModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(LabOrderValueModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="labOrderValueId">
        /// The generalAdvice id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int labOrderValueId);

        /// <summary>
        /// The get delete async in provider encounter.
        /// </summary>
        /// <param name="labOrderValueId">
        /// The generalAdvice id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> updateProviderEncounterAsync(int labOrderValueId);
    }
}
