﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using Shared.EntityModels;

    /// <summary>
    /// The Appointment log Service interface.
    /// </summary>
    public interface IPaymentInitiationLogService
    {
        /// <summary>
        /// The find async.
        /// </summary>
        /// <param name="paymentInitiationLogId">
        /// The appointment log id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<PaymentInitiationLogModel> FindAsync(int paymentInitiationLogId);

        /// <summary>
        /// The modify async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(PaymentInitiationLogModel model);

        /// <summary>
        /// The delete async.
        /// </summary>
        /// <param name="paymentInitiationLogId">
        /// The appointment log Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int paymentInitiationLogId);
    }
}