﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.ProviderSchedule;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IProviderScheduleService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<FilterViewModel>> FetchAsync(FilterModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<EventViewModel>> FetchEventAsync(FilterModel model);

        /// <summary>
        /// the fetch filter event.
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        Task<IEnumerable<EventViewModel>> FetchFilterEvent(FilterModel model);


        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<FilterViewModel>> FetchAvailabilityScheduleAsync(FilterModel model);
    }
}
