﻿using Hims.Shared.EntityModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{
    /// <inheritdoc />
    public interface IReferralDoctorService
    {
        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(ReferralDoctorModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ReferralDoctorModel>> FetchAsync(ReferralDoctorModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(ReferralDoctorModel model);

        /// <summary>
        /// The modify status async.
        /// </summary>
        /// <param name="referralDoctorId">
        /// The specialization id.
        /// </param>
        /// <param name="modifiedBy">
        /// The modified By.
        /// </param>
        /// <param name="status">
        /// The status.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyStatusAsync(int referralDoctorId, int modifiedBy, bool status);


        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="referralDoctorId">
        /// The referralDoctor id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int referralDoctorId);

        /// <summary>
        /// The get provider availability async.
        /// </summary>
        /// <param name="referralDoctorId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FindNameByReferralDoctorId(int referralDoctorId);

        
    }
}
