﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IVisitTypeService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<VisitTypeModel>> FetchAsync(VisitTypeFilterModel model);
        

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(VisitTypeModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        /// 
        
        Task<int> UpdateAsync(VisitTypeModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="visitTypeId">
        /// The specialization id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int visitTypeId);


        /// <summary>
        /// The get provider availability async.
        /// </summary>
        /// <param name="visitTypeId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FindNameByVisitorId(int visitTypeId);


        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="chargeTypesId">
        /// The charge id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyStatusAsync(VisitTypeModel model);
    }
}
