﻿namespace Hims.Infrastructure.Repositories.Middleware
{
    using Domain.Repositories.UnitOfWork;
    using Microsoft.Extensions.DependencyInjection;
    using UnitOfWork;

    /// <summary>
    /// The IoC Container configuration.
    /// </summary>
    public static class IocContainerMiddleware
    {
        /// <summary>
        /// The register services.
        /// </summary>
        /// <param name="services">
        /// The services.
        /// </param>
        /// <returns>
        /// The <see cref="IServiceCollection"/>.
        /// </returns>
        public static IServiceCollection RegisterRepositories(this IServiceCollection services)
        {
            services.AddScoped<IUnitOfWork, UnitOfWork>();
            return services;
        }
    }
}