﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Configurations;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Hims.Domain.Entities;
    using Hims.Shared.Library.Enums;
    using Hims.Shared.Library.Helpers;
    using Hims.Shared.UserModels;
    using Newtonsoft.Json;
    using Shared.EntityModels;


    /// <inheritdoc />
    public class RegisterService : IRegisterService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;


        /// <inheritdoc cref="IRegisterService"/>
        public RegisterService(IUnitOfWork unitOfWork)
        {
            this.unitOfWork = unitOfWork;
        }

        public async Task<int> AddAsync(RegisterModel model)
        {
            try
            {
                var register = new Register
                {
                    Active = true,
                    CreatedBy = model.CreatedBy,
                    CreatedDate = DateTime.Now,
                    LocationId = model.LocationId,
                    AdmissionId = model.AdmissionId,
                };

                switch (model.Type)
                {
                    case RegisterType.FirstFloorAD:
                        register.FirstFloorAD = model.JsonString;
                        break;
                    case RegisterType.SecondFloorAD:
                        register.SecondFloorAD = model.JsonString;
                        break;
                    case RegisterType.ThirdFloorAD:
                        register.ThirdFloorAD = model.JsonString;
                        break;
                    case RegisterType.FFSemiPrivateAD:
                        register.FFSemiPrivateAD = model.JsonString;
                        break;
                    case RegisterType.GroundFloorAD:
                        register.GroundFloorAD = model.JsonString;
                        break;
                    case RegisterType.NICURegister:
                        register.NICURegister = model.JsonString;
                        break;
                    case RegisterType.NICUDeliveryRegister:
                        register.NICUDeliveryRegister = model.JsonString;
                        break;
                    case RegisterType.MidWifeRegister:
                        register.MidWifeRegister = model.JsonString;
                        break;
                    case RegisterType.DayCareAD:
                        register.DayCareAD = model.JsonString;
                        break;
                    case RegisterType.NICUOpRegister:
                        register.NICUOpRegister = model.JsonString;
                        break;
                    case RegisterType.EmergencyRegister:
                        register.EmergencyRegister = model.JsonString;
                        break;
                    case RegisterType.LabourWardRegister:
                        register.LabourWardRegister = model.JsonString;
                        break;
                    case RegisterType.LabourWardAllRegister:
                        register.LabourWardAllRegister = model.JsonString;
                        break;
                    case RegisterType.OTRegister:
                        register.OTRegister = model.JsonString;
                        break;
                    case RegisterType.OTAllRegister:
                        register.OTAllRegister = model.JsonString;
                        break;
                    case RegisterType.ICNRegister:
                        register.ICNRegister = model.JsonString;
                        break;
                    case RegisterType.ThirdFloorLW:
                        register.ThirdFloorLW = model.JsonString;
                        break;
                    case RegisterType.ThirdFloorAllLW:
                        register.ThirdFloorAllLW = model.JsonString;
                        break;
                }
                var response = await this.unitOfWork.Registers.InsertAsync(register);

                return 1;
            }
            catch (Exception ex)
            {
                return -1;
            }
        }

        public Task<RegisterModel> UpdateAsync(RegisterModel model)
        {
            throw new NotImplementedException();
        }
    }
}
