﻿export class TimeConvertHelper {
    static convertTo12HourFormat(hour: number, minute: number) {
        if (hour > 24) {
            return null;
        }
        if (minute > 59) {
            return null;
        }
        let setHour = hour;
        let min;
        switch (hour) {
            case 0:
                setHour = 12;
                break;
            case 13:
                setHour = 1;
                break;
            case 14:
                setHour = 2;
                break;
            case 15:
                setHour = 3;
                break;
            case 16:
                setHour = 4;
                break;
            case 17:
                setHour = 5;
                break;
            case 18:
                setHour = 6;
                break;
            case 19:
                setHour = 7;
                break;
            case 20:
                setHour = 8;
                break;
            case 21:
                setHour = 9;
                break;
            case 22:
                setHour = 10;
                break;
            case 23:
                setHour = 11;
                break;
            case 24:
                setHour = 12;
                break;
        }

        if (minute >= 0 && minute < 10) {
            min = '0' + minute.toString();
        } else {
            min = minute;
        }
        if (hour >= 13 && hour <= 23) {
            return setHour + ":" + min + " " + "PM";
        }
        if (hour === 24 || hour === 0) {
            return setHour + ":" + min + " " + "AM";
        }
        if (hour >= 1 && hour <= 11)
            return setHour + ":" + min + " " + "AM";
        if (hour === 12)
            return setHour + ":" + min + " " + "PM";
    }

    static convertTo24HourFormat(hour: number, minute: number, meridian: string) {
        if (hour > 12) {
            return null;
        }
        if (meridian.toLocaleUpperCase() !== "AM" && meridian.toLocaleUpperCase() !== "PM" && meridian === null) {
            return null;
        }
        let setHour = hour;
        let min;
        if (meridian === 'am' || meridian === 'AM') {
            switch (hour) {
                case 12:
                    setHour = 0;
                    break;
                case 1:
                    setHour = 1;
                    break;
                case 2:
                    setHour = 2;
                    break;
                case 3:
                    setHour = 3;
                    break;
                case 4:
                    setHour = 4;
                    break;
                case 5:
                    setHour = 5;
                    break;
                case 6:
                    setHour = 6;
                    break;
                case 7:
                    setHour = 7;
                    break;
                case 8:
                    setHour = 8;
                    break;
                case 9:
                    setHour = 9;
                    break;
                case 10:
                    setHour = 10;
                    break;
                case 11:
                    setHour = 11;
                    break;
            }
            if (minute >= 0 && minute < 10) {
                min = '0' + minute.toString();
            } else {
                min = minute;
            }
            if (hour === 12 || hour >= 1 && hour <= 11) {
                return setHour + ":" + min;
            }
        }

        if (meridian === 'pm' || meridian === 'PM') {
            switch (hour) {
                case 12:
                    setHour = 12;
                    break;
                case 1:
                    setHour = 13;
                    break;
                case 2:
                    setHour = 14;
                    break;
                case 3:
                    setHour = 15;
                    break;
                case 4:
                    setHour = 16;
                    break;
                case 5:
                    setHour = 17
                    break;
                case 6:
                    setHour = 18;
                    break;
                case 7:
                    setHour = 19;
                    break;
                case 8:
                    setHour = 20;
                    break;
                case 9:
                    setHour = 21;
                    break;
                case 10:
                    setHour = 22;
                    break;
                case 11:
                    setHour = 23;
                    break;
            }
            if (minute >= 0 && minute < 10) {
                min = '0' + minute.toString();
            } else {
                min = minute;
            }
            if (hour === 12 || hour >= 1 && hour <= 11) {
                return setHour + ":" + min;
            }
        }
    }

    static convertToTimeFormat(hours: number, minute: number, second?: number) {
        let hour;
        let min;
        let sec;
        if (hours >= 0 && hours < 10) {
            hour = '0' + hours.toString();
        } else {
            hour = hours;
        }
        if (minute >= 0 && minute < 10) {
            min = '0' + minute.toString();
        } else {
            min = minute;
        }
        if (second >= 0 && second < 10) {
            sec = '0' + second.toString();
        } else {
            sec = second;
        }

        if (second && second !== undefined) {
            return hour + ":" + min + ":" + sec;
        } else {
            return hour + ":" + min
        }
        
    }
}

//TestCases
//Converting 24 Format to 12 Format with meridian
//const hour = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 0]
//hour.forEach((h) => {
//    for (let min = 0; min <= 59; min++) {
//        const time = TimeConvertHelper.convertMeridian(h,min )
//        console.log(time);
//    }
//})

//Converting 12 Format to 24 Format 
//const hour = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
//hour.forEach((h) => {
//    for (let min = 0; min <= 59; min++) {
//        const time = TimeConvertHelper.convertNotMeridian(h, min, 'pm')
//        console.log(time);
//    }
//})