namespace Hims.Shared.Dapper.Attributes.Joins
{
    using System;

    /// <inheritdoc />
    /// <summary>
    ///     Base JOIN for LEFT/INNER/RIGHT
    /// </summary>
    public abstract class JoinAttributeBase : Attribute
    {
        /// <inheritdoc />
        /// <summary>
        /// Initializes a new instance of the <see cref="T:Hims.Shared.Dapper.Attributes.Joins.JoinAttributeBase" /> class.
        ///     Constructor
        /// </summary>
        protected JoinAttributeBase()
        {
        }

        /// <inheritdoc />
        /// <summary>
        ///     Constructor
        /// </summary>
        protected JoinAttributeBase(string tableName, string key, string externalKey, string tableSchema, string tableAlias)
        {
            this.TableName = tableName;
            this.Key = key;
            this.ExternalKey = externalKey;
            this.TableSchema = tableSchema;
            this.TableAlias = tableAlias == string.Empty ? this.GetAlias() : tableAlias;
        }

        /// <summary>
        /// Gets or sets the table name.
        /// </summary>
        public string TableName { get; set; }

        /// <summary>
        /// Gets or sets the table schema.
        /// </summary>
        public string TableSchema { get; set; }

        /// <summary>
        /// Gets or sets the key.
        /// </summary>
        public string Key { get; set; }

        /// <summary>
        /// Gets or sets the external key.
        /// </summary>
        public string ExternalKey { get; set; }

        /// <summary>
        /// Gets or sets the table alias.
        /// </summary>
        public string TableAlias { get; set; }

        /// <summary>
        /// The get alias.
        /// </summary>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        private string GetAlias() => $"{this.TableName}_{this.Key}";
    }
}