﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The appointment support log model.
    /// </summary>
    public class AppointmentSupportLogModel
    {
        /// <summary>
        /// Gets or sets the appointment support log id.
        /// </summary>
        public long AppointmentSupportLogId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the assignee id.
        /// </summary>
        public int? AssigneeId { get; set; }

        /// <summary>
        /// Gets or sets the createdby.
        /// </summary>
        public short modifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the audio.
        /// </summary>
        public string Audio { get; set; }

        /// <summary>
        /// Gets or sets the video.
        /// </summary>
        public string Video { get; set; }

        /// <summary>
        /// Gets or sets the document.
        /// </summary>
        public string Document { get; set; }

        /// <summary>
        /// Gets or sets the invoice.
        /// </summary>
        public string Invoice { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment time string.
        /// </summary>
        public string AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string ToDate { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the assignee name.
        /// </summary>
        public string AssigneeName { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is admin.
        /// </summary>
        public bool IsAdmin { get; set; }
        
        /// <summary>
        /// Gets or sets a value indicating whether is admin.
        /// </summary>
        public bool IsAdminFilaterApplied { get; set; }

        /// <summary>
        /// Gets or sets the patient account id.
        /// </summary>
        public int PatientAccountId { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the call status.
        /// </summary>
        public string CallStatus { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is online.
        /// </summary>
        public bool IsOnline { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? LocationId { get; set; }
    }
}
