﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The dental prescription model.
    /// </summary>
    public class DentalPrescriptionModel
    {
         /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment time string.
        /// </summary>
        public string AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int DentalEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the medications.
        /// </summary>
        public string Medications { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the specialization name.
        /// </summary>
        public string SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        public string PracticeName { get; set; }

        /// <summary>
        /// Gets or sets the practice location.
        /// </summary>
        public string PracticeLocation { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public string PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public short PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient date of birth.
        /// </summary>
        public DateTime? PatientDateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the provider no.
        /// </summary>
        public string ProviderNo { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the educations.
        /// </summary>
        public string Educations { get; set; }

        /// <summary>
        /// Gets or sets the medication comment.
        /// </summary>
        public string MedicationComment { get; set; }
    }
}
